# Lab Result Portal (Laravel + Blade) — Patch Pack

This ZIP is a **drop-in patch** for a fresh Laravel project using **Laravel Breeze (Blade)**.

## Quick setup (VS Code)
1) Create a fresh Laravel project on your PC:
   - Install PHP 8.2+, Composer, Node.js
   - Create project folder, then:
     ```bash
     composer create-project laravel/laravel lab-result-portal
     cd lab-result-portal
     composer require laravel/breeze --dev
     php artisan breeze:install blade
     npm install && npm run build
     ```

2) Copy/merge the contents of this patch ZIP **into your Laravel project root** (overwrite when prompted).

3) Configure `.env` and run migrations:
   ```bash
   php artisan key:generate
   php artisan migrate
   php artisan storage:link
   ```

4) Create a Super Admin user (example):
   ```bash
   php artisan tinker
   use App\Models\User; use Illuminate\Support\Facades\Hash;
   User::create([
     'name'=>'Super Admin', 'email'=>'admin@lab.test', 'phone'=>'08000000000',
     'password'=>Hash::make('password'), 'role'=>'super_admin', 'is_active'=>true,
   ]);
   ```

## What this patch adds
- Roles middleware: `role:super_admin,lab_manager,lab_staff`
- Admin: Labs CRUD
- Admin: Test Catalog CRUD
- Admin: Per-lab test pricing overrides
- Frontdesk: Patients + Orders (tests + payments + totals)

## Routes
- `/admin/labs` (super_admin)
- `/admin/tests` (super_admin)
- `/admin/labs/{lab}/pricing` (super_admin)
- `/frontdesk/patients` (staff/manager/super_admin)

