<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\LabRequest;
use App\Models\Lab;
use Illuminate\Support\Facades\Storage;

class LabController extends Controller
{
    public function index()
    {
        $labs = Lab::query()->latest()->paginate(15);
        return view('admin.labs.index', compact('labs'));
    }

    public function create()
    {
        return view('admin.labs.create');
    }

    public function store(LabRequest $request)
    {
        $data = $request->validated();
        $data['is_active'] = (bool)($data['is_active'] ?? true);

        if ($request->hasFile('logo')) {
            $data['logo_path'] = $request->file('logo')->store('logos', 'public');
        }

        $lab = Lab::create($data);

        return redirect()->route('admin.labs.index')->with('success', "Lab created successfully. Assigned Lab ID: {$lab->id}.");
    }

    public function show(Lab $lab)
    {
        return view('admin.labs.show', compact('lab'));
    }

    public function edit(Lab $lab)
    {
        return view('admin.labs.edit', compact('lab'));
    }

    public function update(LabRequest $request, Lab $lab)
    {
        $data = $request->validated();
        $data['is_active'] = (bool)($data['is_active'] ?? false);

        if ($request->hasFile('logo')) {
            if ($lab->logo_path) {
                Storage::disk('public')->delete($lab->logo_path);
            }
            $data['logo_path'] = $request->file('logo')->store('logos', 'public');
        }

        $lab->update($data);

        return redirect()->route('admin.labs.index')->with('success', 'Lab updated successfully.');
    }

    public function destroy(Lab $lab)
    {
        if ($lab->logo_path) {
            Storage::disk('public')->delete($lab->logo_path);
        }

        $lab->delete();

        return redirect()->route('admin.labs.index')->with('success', 'Lab deleted.');
    }
}
