<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EnsurePatientAuthenticated
{
    public function handle(Request $request, Closure $next)
    {
        $patient = Auth::guard('patient')->user();

        if (!$patient) {
            return redirect()->route('patient.login');
        }

        $request->setUserResolver(static fn () => $patient);

        return $next($request);
    }
}
