<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class LabPricingRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user() && $this->user()->role === 'super_admin';
    }

    public function rules(): array
    {
        return [
            'prices' => ['required','array'],
            'prices.*' => ['nullable','integer','min:0'],
        ];
    }
}
