<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class TestCatalogRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user() && $this->user()->role === 'super_admin';
    }

    public function rules(): array
    {
        $id = $this->route('test')?->id;

        return [
            'code' => ['required','string','max:50','unique:test_catalog,code,' . $id],
            'name' => ['required','string','max:255'],
            'category_id' => ['required','exists:test_categories,id'],
            'default_price' => ['required','integer','min:0'],
            'is_active' => ['nullable','boolean'],
        ];
    }
}
