<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Model;

class LabTestPrice extends Model
{
    protected $fillable = ['lab_id', 'test_id', 'price'];

    protected $casts = [
        'price' => 'decimal:2',
    ];

    public function lab(): BelongsTo
    {
        return $this->belongsTo(Lab::class);
    }

    public function test(): BelongsTo
    {
        return $this->belongsTo(TestCatalog::class, 'test_id');
    }
}
