<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class Setting extends Model
{
    use HasFactory;

    protected $fillable = [
        'scope',
        'lab_id',
        'key',
        'value',
    ];

    public static function getGlobal(string $key, ?string $default = null): ?string
    {
        return Cache::remember("settings.global.{$key}", now()->addMinutes(10), static function () use ($key, $default) {
            return static::query()
                ->where('scope', 'global')
                ->whereNull('lab_id')
                ->where('key', $key)
                ->value('value') ?? $default;
        });
    }

    public static function setGlobal(string $key, ?string $value): void
    {
        static::query()->updateOrCreate(
            ['scope' => 'global', 'lab_id' => null, 'key' => $key],
            ['value' => $value]
        );

        Cache::forget("settings.global.{$key}");
    }
}
