<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Model;

class TestCatalog extends Model
{
    protected $table = 'test_catalog';

    protected $fillable = [
        'code',
        'name',
        'category_id',
        'category',
        'default_price',
        'is_active',
    ];

    protected $casts = [
        'default_price' => 'decimal:2',
        'is_active' => 'boolean',
    ];

    public function labPrices(): HasMany
    {
        return $this->hasMany(LabTestPrice::class, 'test_id');
    }

    public function categoryRelation(): BelongsTo
    {
        return $this->belongsTo(TestCategory::class, 'category_id');
    }
}
