<?php

namespace App\Providers;

use App\Models\Setting;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Schema::defaultStringLength(191);

        $brandName = config('app.name', 'Lab Result Portal');
        $brandLogoPath = null;
        $frontendSettings = [
            'hero_title' => 'Science Laboratory',
            'hero_subtitle' => 'Smart workflow for patient records, orders, billing, and secure result access.',
            'contact_title' => 'Contact Us',
            'contact_description' => 'Reach our support team for lab, result, billing, or account help.',
            'contact_email' => '',
            'contact_phone' => '',
            'contact_address' => '',
            'whatsapp_number' => '',
            'facebook_url' => '',
            'instagram_url' => '',
            'x_url' => '',
            'linkedin_url' => '',
        ];

        try {
            if (Schema::hasTable('settings')) {
                $brandName = Setting::getGlobal('app_name', $brandName) ?: $brandName;
                $brandLogoPath = Setting::getGlobal('app_logo_path');
                $frontendSettings['hero_title'] = Setting::getGlobal('frontend_hero_title', $frontendSettings['hero_title']) ?: $frontendSettings['hero_title'];
                $frontendSettings['hero_subtitle'] = Setting::getGlobal('frontend_hero_subtitle', $frontendSettings['hero_subtitle']) ?: $frontendSettings['hero_subtitle'];
                $frontendSettings['contact_title'] = Setting::getGlobal('frontend_contact_title', $frontendSettings['contact_title']) ?: $frontendSettings['contact_title'];
                $frontendSettings['contact_description'] = Setting::getGlobal('frontend_contact_description', $frontendSettings['contact_description']) ?: $frontendSettings['contact_description'];
                $frontendSettings['contact_email'] = Setting::getGlobal('frontend_contact_email', '') ?: '';
                $frontendSettings['contact_phone'] = Setting::getGlobal('frontend_contact_phone', '') ?: '';
                $frontendSettings['contact_address'] = Setting::getGlobal('frontend_contact_address', '') ?: '';
                $frontendSettings['whatsapp_number'] = Setting::getGlobal('frontend_whatsapp_number', '') ?: '';
                $frontendSettings['facebook_url'] = Setting::getGlobal('frontend_facebook_url', '') ?: '';
                $frontendSettings['instagram_url'] = Setting::getGlobal('frontend_instagram_url', '') ?: '';
                $frontendSettings['x_url'] = Setting::getGlobal('frontend_x_url', '') ?: '';
                $frontendSettings['linkedin_url'] = Setting::getGlobal('frontend_linkedin_url', '') ?: '';
            }
        } catch (\Throwable) {
            // Ignore branding DB lookup failures during early boot/migrate.
        }

        View::share('brandName', $brandName);
        View::share('brandLogoPath', $brandLogoPath);
        View::share('brandLogoUrl', $brandLogoPath ? asset('storage/'.$brandLogoPath) : null);
        View::share('frontendSettings', $frontendSettings);
    }
}
