<?php

namespace App\Services;

use App\Models\Order;

class OrderTotalsService
{
    public function recalculate(Order $order): void
    {
        $order->loadMissing(['items', 'payments']);

        $subtotal = (float) $order->items->sum('line_total');
        $discount = (float) $order->discount;
        $total = max($subtotal - $discount, 0);
        $paid = (float) $order->payments->sum('amount');
        $balance = max($total - $paid, 0);

        $order->forceFill([
            'subtotal' => $subtotal,
            'total' => $total,
            'paid' => $paid,
            'balance' => $balance,
            'status' => $this->statusFromBalance($order->status, $balance),
        ])->save();
    }

    private function statusFromBalance(string $currentStatus, float $balance): string
    {
        if (in_array($currentStatus, ['ready', 'delivered'], true)) {
            return $currentStatus;
        }

        return $balance > 0 ? 'pending' : 'paid';
    }
}
