<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->unsignedBigInteger('lab_id')->nullable()->after('id');
            $table->string('phone', 30)->nullable()->unique()->after('email');
            $table->string('role', 30)->default('lab_staff')->after('password');
            $table->boolean('is_active')->default(true)->after('role');
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['lab_id', 'phone', 'role', 'is_active']);
        });
    }
};
