<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('otps', function (Blueprint $table) {
            $table->foreignId('patient_id')->nullable()->after('id')->constrained()->nullOnDelete();
            $table->string('plain_code', 10)->nullable()->after('code_hash');
            $table->index(['patient_id', 'created_at']);
        });
    }

    public function down(): void
    {
        Schema::table('otps', function (Blueprint $table) {
            $table->dropIndex(['patient_id', 'created_at']);
            $table->dropConstrainedForeignId('patient_id');
            $table->dropColumn('plain_code');
        });
    }
};
