<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('patients', function (Blueprint $table) {
            $table->foreignId('lab_id')->nullable()->after('id')->constrained()->nullOnDelete();
            $table->index('lab_id');
        });

        DB::table('patients')
            ->whereNull('lab_id')
            ->orderBy('id')
            ->chunkById(100, static function ($patients): void {
                foreach ($patients as $patient) {
                    $labId = DB::table('orders')
                        ->where('patient_id', $patient->id)
                        ->orderBy('id')
                        ->value('lab_id');

                    if ($labId) {
                        DB::table('patients')->where('id', $patient->id)->update(['lab_id' => $labId]);
                    }
                }
            });

        $firstLabId = DB::table('labs')->orderBy('id')->value('id');
        if ($firstLabId) {
            DB::table('patients')->whereNull('lab_id')->update(['lab_id' => $firstLabId]);
        }
    }

    public function down(): void
    {
        Schema::table('patients', function (Blueprint $table) {
            $table->dropIndex(['lab_id']);
            $table->dropConstrainedForeignId('lab_id');
        });
    }
};
