<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800">Branding And Frontend Settings</h2>
    </x-slot>

    <div class="py-8">
        <div class="max-w-5xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white shadow rounded p-6">
                @if (session('success'))
                    <div class="mb-4 rounded border border-green-200 bg-green-50 px-4 py-3 text-sm text-green-800">
                        {{ session('success') }}
                    </div>
                @endif

                <form method="POST" action="{{ route('admin.branding.update') }}" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    <div class="space-y-8">
                        <section>
                            <h3 class="text-base font-semibold text-gray-900">Brand Identity</h3>
                            <div class="mt-4 grid gap-5 sm:grid-cols-2">
                                <div class="sm:col-span-2">
                                    <label for="app_name" class="block text-sm font-medium text-gray-700">Application Name</label>
                                    <input
                                        id="app_name"
                                        name="app_name"
                                        type="text"
                                        class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                                        value="{{ old('app_name', $appName) }}"
                                        required
                                    >
                                    @error('app_name')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div class="sm:col-span-2">
                                    <label for="logo" class="block text-sm font-medium text-gray-700">Application Logo</label>
                                    <input
                                        id="logo"
                                        name="logo"
                                        type="file"
                                        accept="image/*"
                                        class="mt-1 block w-full text-sm text-gray-700 file:mr-4 file:rounded file:border-0 file:bg-indigo-50 file:px-3 file:py-2 file:text-sm file:font-semibold file:text-indigo-700 hover:file:bg-indigo-100"
                                    >
                                    <p class="mt-1 text-xs text-gray-500">PNG, JPG, WEBP or SVG. Max 4MB.</p>
                                    @error('logo')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                @if ($appLogoPath)
                                    <div class="sm:col-span-2">
                                        <p class="text-sm font-medium text-gray-700">Current Logo</p>
                                        <img
                                            src="{{ asset('storage/'.$appLogoPath) }}"
                                            alt="{{ $appName }}"
                                            class="mt-2 h-16 w-auto rounded border border-gray-200 bg-white p-2 object-contain"
                                        >
                                    </div>
                                @endif
                            </div>
                        </section>

                        <section class="border-t border-gray-200 pt-6">
                            <h3 class="text-base font-semibold text-gray-900">Landing Page Content</h3>
                            <div class="mt-4 grid gap-5 sm:grid-cols-2">
                                <div class="sm:col-span-2">
                                    <label for="frontend_hero_title" class="block text-sm font-medium text-gray-700">Hero Title</label>
                                    <input id="frontend_hero_title" name="frontend_hero_title" type="text" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" value="{{ old('frontend_hero_title', $frontend['frontend_hero_title'] ?? '') }}" required>
                                    @error('frontend_hero_title')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div class="sm:col-span-2">
                                    <label for="frontend_hero_subtitle" class="block text-sm font-medium text-gray-700">Hero Subtitle</label>
                                    <textarea id="frontend_hero_subtitle" name="frontend_hero_subtitle" rows="3" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" required>{{ old('frontend_hero_subtitle', $frontend['frontend_hero_subtitle'] ?? '') }}</textarea>
                                    @error('frontend_hero_subtitle')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>
                        </section>

                        <section class="border-t border-gray-200 pt-6">
                            <h3 class="text-base font-semibold text-gray-900">Contact Us</h3>
                            <div class="mt-4 grid gap-5 sm:grid-cols-2">
                                <div class="sm:col-span-2">
                                    <label for="frontend_contact_title" class="block text-sm font-medium text-gray-700">Section Title</label>
                                    <input id="frontend_contact_title" name="frontend_contact_title" type="text" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" value="{{ old('frontend_contact_title', $frontend['frontend_contact_title'] ?? '') }}" required>
                                    @error('frontend_contact_title')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div class="sm:col-span-2">
                                    <label for="frontend_contact_description" class="block text-sm font-medium text-gray-700">Section Description</label>
                                    <textarea id="frontend_contact_description" name="frontend_contact_description" rows="3" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ old('frontend_contact_description', $frontend['frontend_contact_description'] ?? '') }}</textarea>
                                    @error('frontend_contact_description')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="frontend_contact_email" class="block text-sm font-medium text-gray-700">Support Email</label>
                                    <input id="frontend_contact_email" name="frontend_contact_email" type="email" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" value="{{ old('frontend_contact_email', $frontend['frontend_contact_email'] ?? '') }}">
                                    @error('frontend_contact_email')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="frontend_contact_phone" class="block text-sm font-medium text-gray-700">Support Phone</label>
                                    <input id="frontend_contact_phone" name="frontend_contact_phone" type="text" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" value="{{ old('frontend_contact_phone', $frontend['frontend_contact_phone'] ?? '') }}" placeholder="+234...">
                                    @error('frontend_contact_phone')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div class="sm:col-span-2">
                                    <label for="frontend_contact_address" class="block text-sm font-medium text-gray-700">Address</label>
                                    <input id="frontend_contact_address" name="frontend_contact_address" type="text" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" value="{{ old('frontend_contact_address', $frontend['frontend_contact_address'] ?? '') }}">
                                    @error('frontend_contact_address')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div class="sm:col-span-2">
                                    <label for="frontend_whatsapp_number" class="block text-sm font-medium text-gray-700">Official WhatsApp Business Line</label>
                                    <input id="frontend_whatsapp_number" name="frontend_whatsapp_number" type="text" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" value="{{ old('frontend_whatsapp_number', $frontend['frontend_whatsapp_number'] ?? '') }}" placeholder="+2348012345678">
                                    <p class="mt-1 text-xs text-gray-500">Use international format so the direct WhatsApp link works correctly.</p>
                                    @error('frontend_whatsapp_number')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>
                        </section>

                        <section class="border-t border-gray-200 pt-6">
                            <h3 class="text-base font-semibold text-gray-900">Social Media Links</h3>
                            <div class="mt-4 grid gap-5 sm:grid-cols-2">
                                <div>
                                    <label for="frontend_facebook_url" class="block text-sm font-medium text-gray-700">Facebook URL</label>
                                    <input id="frontend_facebook_url" name="frontend_facebook_url" type="url" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" value="{{ old('frontend_facebook_url', $frontend['frontend_facebook_url'] ?? '') }}" placeholder="https://facebook.com/...">
                                    @error('frontend_facebook_url')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="frontend_instagram_url" class="block text-sm font-medium text-gray-700">Instagram URL</label>
                                    <input id="frontend_instagram_url" name="frontend_instagram_url" type="url" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" value="{{ old('frontend_instagram_url', $frontend['frontend_instagram_url'] ?? '') }}" placeholder="https://instagram.com/...">
                                    @error('frontend_instagram_url')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="frontend_x_url" class="block text-sm font-medium text-gray-700">X (Twitter) URL</label>
                                    <input id="frontend_x_url" name="frontend_x_url" type="url" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" value="{{ old('frontend_x_url', $frontend['frontend_x_url'] ?? '') }}" placeholder="https://x.com/...">
                                    @error('frontend_x_url')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="frontend_linkedin_url" class="block text-sm font-medium text-gray-700">LinkedIn URL</label>
                                    <input id="frontend_linkedin_url" name="frontend_linkedin_url" type="url" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" value="{{ old('frontend_linkedin_url', $frontend['frontend_linkedin_url'] ?? '') }}" placeholder="https://linkedin.com/company/...">
                                    @error('frontend_linkedin_url')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>
                        </section>
                    </div>

                    <div class="mt-8 flex justify-end gap-2">
                        <a href="{{ route('dashboard') }}" class="px-4 py-2 border rounded">Cancel</a>
                        <button class="px-4 py-2 bg-indigo-600 text-white rounded">Save Settings</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>
