@php $isEdit = isset($category); @endphp

<div class="grid grid-cols-1 md:grid-cols-2 gap-4">
    <div>
        <label class="block text-sm font-medium">Category Name</label>
        <input name="name" class="w-full border rounded p-2" value="{{ old('name', $category->name ?? '') }}" required>
        @error('name') <div class="text-red-600 text-sm">{{ $message }}</div> @enderror
    </div>

    <div class="flex items-center gap-2 mt-7">
        <input type="checkbox" name="is_active" value="1" {{ old('is_active', $category->is_active ?? true) ? 'checked' : '' }}>
        <label class="text-sm">Active</label>
    </div>
</div>
