<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800">Lab Pricing: {{ $lab->name }}</h2>
            <a href="{{ route('admin.labs.index') }}" class="px-4 py-2 border rounded">Back to Labs</a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="max-w-6xl mx-auto sm:px-6 lg:px-8">

            @if(session('success'))
                <div class="mb-4 p-3 bg-green-100 text-green-800 rounded">{{ session('success') }}</div>
            @endif

            <div class="bg-white shadow rounded p-6">
                <div class="mb-4 text-sm text-gray-600">
                    Leave a price empty to use the test's **default price**.
                </div>

                <form method="POST" action="{{ route('admin.labs.pricing.update', $lab) }}">
                    @csrf @method('PUT')

                    <div class="overflow-x-auto">
                        <table class="min-w-full text-sm">
                            <thead>
                                <tr class="text-left border-b">
                                    <th class="py-2">Code</th>
                                    <th class="py-2">Test</th>
                                    <th class="py-2">Default (₦)</th>
                                    <th class="py-2">Override (₦)</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($tests as $t)
                                    @php $ov = $overrides[$t->id] ?? null; @endphp
                                    <tr class="border-b">
                                        <td class="py-2">{{ $t->code }}</td>
                                        <td class="py-2">{{ $t->name }}</td>
                                        <td class="py-2">₦{{ number_format($t->default_price) }}</td>
                                        <td class="py-2">
                                            <input class="border rounded p-2 w-48"
                                                   name="prices[{{ $t->id }}]"
                                                   value="{{ old('prices.'.$t->id, $ov->price ?? '') }}"
                                                   placeholder="leave empty">
                                            @error('prices.'.$t->id)
                                                <div class="text-red-600 text-xs mt-1">{{ $message }}</div>
                                            @enderror
                                        </td>
                                    </tr>
                                @endforeach
                                @if($tests->count() === 0)
                                    <tr><td colspan="4" class="py-6 text-center text-gray-500">No tests available.</td></tr>
                                @endif
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-6 flex justify-end">
                        <button class="px-4 py-2 bg-indigo-600 text-white rounded">Save Pricing</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>
