@php $isEdit = isset($lab); @endphp

<div class="grid grid-cols-1 md:grid-cols-2 gap-4">
    <div>
        <label class="block text-sm font-medium">Lab Name</label>
        <input name="name" class="w-full border rounded p-2" value="{{ old('name', $lab->name ?? '') }}" required>
        @error('name') <div class="text-red-600 text-sm">{{ $message }}</div> @enderror
    </div>

    <div>
        <label class="block text-sm font-medium">Lab ID</label>
        <input class="w-full border rounded p-2 bg-gray-100" value="{{ $lab->id ?? 'Auto-generated after create' }}" disabled>
    </div>

    <div>
        <label class="block text-sm font-medium">Branch Name</label>
        <input name="branch_name" class="w-full border rounded p-2" value="{{ old('branch_name', $lab->branch_name ?? '') }}">
        @error('branch_name') <div class="text-red-600 text-sm">{{ $message }}</div> @enderror
    </div>

    <div>
        <label class="block text-sm font-medium">Phone</label>
        <input name="phone" class="w-full border rounded p-2" value="{{ old('phone', $lab->phone ?? '') }}">
        @error('phone') <div class="text-red-600 text-sm">{{ $message }}</div> @enderror
    </div>

    <div>
        <label class="block text-sm font-medium">Email</label>
        <input name="email" type="email" class="w-full border rounded p-2" value="{{ old('email', $lab->email ?? '') }}">
        @error('email') <div class="text-red-600 text-sm">{{ $message }}</div> @enderror
    </div>

    <div class="md:col-span-2">
        <label class="block text-sm font-medium">Address</label>
        <input name="address" class="w-full border rounded p-2" value="{{ old('address', $lab->address ?? '') }}">
        @error('address') <div class="text-red-600 text-sm">{{ $message }}</div> @enderror
    </div>

    <div>
        <label class="block text-sm font-medium">Logo</label>
        <input type="file" name="logo" class="w-full border rounded p-2">
        @error('logo') <div class="text-red-600 text-sm">{{ $message }}</div> @enderror

        @if($isEdit && $lab->logo_path)
            <div class="mt-2 text-sm text-gray-600">
                Current: <a class="text-indigo-600" target="_blank" href="{{ asset('storage/'.$lab->logo_path) }}">View logo</a>
            </div>
        @endif
    </div>

    <div class="md:col-span-2 flex items-center gap-2">
        <input type="checkbox" name="is_active" value="1" {{ old('is_active', $lab->is_active ?? true) ? 'checked' : '' }}>
        <label class="text-sm">Active</label>
    </div>
</div>
