<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">Labs</h2>
            <a href="{{ route('admin.labs.create') }}" class="px-4 py-2 bg-indigo-600 text-white rounded">Add Lab</a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">

            @if(session('success'))
                <div class="mb-4 p-3 bg-green-100 text-green-800 rounded">{{ session('success') }}</div>
            @endif

            <div class="bg-white shadow rounded p-4 overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead>
                        <tr class="text-left border-b">
                            <th class="py-2">Lab ID</th>
                            <th class="py-2">Name</th>
                            <th class="py-2">Branch</th>
                            <th class="py-2">Phone</th>
                            <th class="py-2">Status</th>
                            <th class="py-2 text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($labs as $lab)
                            <tr class="border-b">
                                <td class="py-2 font-semibold">{{ $lab->id }}</td>
                                <td class="py-2">{{ $lab->name }}</td>
                                <td class="py-2">{{ $lab->branch_name ?: '-' }}</td>
                                <td class="py-2">{{ $lab->phone }}</td>
                                <td class="py-2">
                                    @if($lab->is_active)
                                        <span class="px-2 py-1 rounded bg-green-100 text-green-700">Active</span>
                                    @else
                                        <span class="px-2 py-1 rounded bg-gray-100 text-gray-700">Inactive</span>
                                    @endif
                                </td>
                                <td class="py-2 text-right space-x-2">
                                    <a class="text-indigo-600" href="{{ route('admin.labs.show', $lab) }}">View</a>
                                    <a class="text-blue-600" href="{{ route('admin.labs.edit', $lab) }}">Edit</a>
                                    <a class="text-purple-600" href="{{ route('admin.labs.pricing.edit', $lab) }}">Pricing</a>
                                    <form class="inline" method="POST" action="{{ route('admin.labs.destroy', $lab) }}" onsubmit="return confirm('Delete this lab?')">
                                        @csrf @method('DELETE')
                                        <button class="text-red-600" type="submit">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                        @if($labs->count() === 0)
                            <tr><td colspan="6" class="py-6 text-center text-gray-500">No labs yet.</td></tr>
                        @endif
                    </tbody>
                </table>

                <div class="mt-4">{{ $labs->links() }}</div>
            </div>
        </div>
    </div>
</x-app-layout>
