<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800">Lab Details</h2>
            <a class="px-4 py-2 border rounded" href="{{ route('admin.labs.pricing.edit', $lab) }}">Manage Pricing</a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white shadow rounded p-6 space-y-3">
                <div><span class="text-gray-500">Lab ID:</span> <b>{{ $lab->id }}</b></div>
                <div><span class="text-gray-500">Name:</span> <b>{{ $lab->name }}</b></div>
                <div><span class="text-gray-500">Branch:</span> {{ $lab->branch_name ?? '-' }}</div>
                <div><span class="text-gray-500">Phone:</span> {{ $lab->phone ?? '-' }}</div>
                <div><span class="text-gray-500">Email:</span> {{ $lab->email ?? '-' }}</div>
                <div><span class="text-gray-500">Address:</span> {{ $lab->address ?? '-' }}</div>
                <div><span class="text-gray-500">Status:</span> {{ $lab->is_active ? 'Active' : 'Inactive' }}</div>

                @if($lab->logo_path)
                    <div>
                        <span class="text-gray-500">Logo:</span>
                        <a class="text-indigo-600" target="_blank" href="{{ asset('storage/'.$lab->logo_path) }}">View</a>
                    </div>
                @endif

                <div class="pt-4 flex gap-2">
                    <a href="{{ route('admin.labs.edit', $lab) }}" class="px-4 py-2 bg-blue-600 text-white rounded">Edit</a>
                    <a href="{{ route('admin.labs.index') }}" class="px-4 py-2 border rounded">Back</a>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
