@php $isEdit = isset($test); @endphp

<div class="grid grid-cols-1 md:grid-cols-2 gap-4">
    <div>
        <label class="block text-sm font-medium">Code</label>
        <input name="code" class="w-full border rounded p-2" value="{{ old('code', $test->code ?? '') }}" required>
        @error('code') <div class="text-red-600 text-sm">{{ $message }}</div> @enderror
    </div>

    <div>
        <label class="block text-sm font-medium">Name</label>
        <input name="name" class="w-full border rounded p-2" value="{{ old('name', $test->name ?? '') }}" required>
        @error('name') <div class="text-red-600 text-sm">{{ $message }}</div> @enderror
    </div>

    <div>
        <label class="block text-sm font-medium">Category</label>
        <select name="category_id" class="w-full border rounded p-2" required>
            <option value="">Select Category</option>
            @foreach($categories as $category)
                <option value="{{ $category->id }}" @selected((string) old('category_id', $test->category_id ?? '') === (string) $category->id)>
                    {{ $category->name }}
                </option>
            @endforeach
        </select>
        @error('category_id') <div class="text-red-600 text-sm">{{ $message }}</div> @enderror
    </div>

    <div>
        <label class="block text-sm font-medium">Default Price (&#8358;)</label>
        <input name="default_price" class="w-full border rounded p-2" value="{{ old('default_price', $test->default_price ?? 0) }}" required>
        @error('default_price') <div class="text-red-600 text-sm">{{ $message }}</div> @enderror
    </div>

    <div class="md:col-span-2 flex items-center gap-2">
        <input type="checkbox" name="is_active" value="1" {{ old('is_active', $test->is_active ?? true) ? 'checked' : '' }}>
        <label class="text-sm">Active</label>
    </div>
</div>
