<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">Test Catalog</h2>
            <div class="flex items-center gap-2">
                <a href="{{ route('admin.categories.index') }}" class="px-4 py-2 border rounded">Manage Categories</a>
                <a href="{{ route('admin.tests.create') }}" class="px-4 py-2 bg-indigo-600 text-white rounded">Add Test</a>
            </div>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">

            @if(session('success'))
                <div class="mb-4 p-3 bg-green-100 text-green-800 rounded">{{ session('success') }}</div>
            @endif

            <div class="bg-white shadow rounded p-4 overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead>
                        <tr class="text-left border-b">
                            <th class="py-2">Code</th>
                            <th class="py-2">Name</th>
                            <th class="py-2">Category</th>
                            <th class="py-2">Default Price</th>
                            <th class="py-2">Status</th>
                            <th class="py-2 text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($tests as $t)
                            <tr class="border-b">
                                <td class="py-2">{{ $t->code }}</td>
                                <td class="py-2">{{ $t->name }}</td>
                                <td class="py-2">{{ $t->categoryRelation?->name ?? '-' }}</td>
                                <td class="py-2">&#8358;{{ number_format((float) $t->default_price) }}</td>
                                <td class="py-2">
                                    @if($t->is_active)
                                        <span class="px-2 py-1 rounded bg-green-100 text-green-700">Active</span>
                                    @else
                                        <span class="px-2 py-1 rounded bg-gray-100 text-gray-700">Inactive</span>
                                    @endif
                                </td>
                                <td class="py-2 text-right space-x-2">
                                    <a class="text-blue-600" href="{{ route('admin.tests.edit', $t) }}">Edit</a>
                                    <form class="inline" method="POST" action="{{ route('admin.tests.destroy', $t) }}" onsubmit="return confirm('Delete this test?')">
                                        @csrf @method('DELETE')
                                        <button class="text-red-600" type="submit">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                        @if($tests->count() === 0)
                            <tr><td colspan="6" class="py-6 text-center text-gray-500">No tests created.</td></tr>
                        @endif
                    </tbody>
                </table>
                <div class="mt-4">{{ $tests->links() }}</div>
            </div>
        </div>
    </div>
</x-app-layout>
