<x-guest-layout>
    <div class="mb-6 overflow-hidden rounded-2xl border border-slate-200 bg-gradient-to-br from-sky-50 via-indigo-50 to-white">
        <div class="grid gap-3 p-4 sm:grid-cols-[1.1fr_.9fr] sm:p-5">
            <div class="flex flex-col justify-center">
                <p class="text-xs font-semibold uppercase tracking-[0.12em] text-sky-700">Staff Access</p>
                <h2 class="mt-1 text-lg font-semibold text-slate-900 sm:text-xl">Secure Laboratory Login</h2>
                <p class="mt-1 text-sm text-slate-600">Sign in to manage patients, orders and lab results.</p>
            </div>
            <div class="rounded-xl border border-slate-100 bg-white p-2 shadow-sm">
                <img
                    src="{{ asset('images/landing-lab-hero.svg') }}"
                    alt="Laboratory illustration"
                    class="h-32 w-full rounded-lg object-cover object-center sm:h-36"
                >
            </div>
        </div>
    </div>

    <div class="mb-6">
        <h1 class="auth-page-title">Sign in</h1>
        <p class="auth-page-text">Use your staff account credentials to access the portal.</p>
    </div>

    <!-- Session Status -->
    <x-auth-session-status class="mb-4" :status="session('status')" />

    <form method="POST" action="{{ route('login') }}" class="auth-form-stack">
        @csrf

        <!-- Email Address -->
        <div>
            <x-input-label for="email" :value="__('Email')" />
            <x-text-input id="email" class="block mt-1 w-full" type="email" name="email" :value="old('email')" placeholder="you@example.com" required autofocus autocomplete="username" />
            <x-input-error :messages="$errors->get('email')" class="mt-2" />
        </div>

        <!-- Password -->
        <div>
            <x-input-label for="password" :value="__('Password')" />

            <x-password-input id="password" class="block mt-1 w-full"
                              name="password"
                              placeholder="Enter your password"
                              required autocomplete="current-password" />

            <x-input-error :messages="$errors->get('password')" class="mt-2" />
        </div>

        <!-- Remember Me -->
        <div class="flex items-center justify-between gap-3">
            <label for="remember_me" class="inline-flex items-center">
                <input id="remember_me" type="checkbox" class="rounded border-slate-300 text-sky-600 shadow-sm focus:ring-sky-500" name="remember">
                <span class="ml-2 text-sm text-slate-700">{{ __('Remember me') }}</span>
            </label>

            @if (Route::has('password.request'))
                <a class="auth-link" href="{{ route('password.request') }}">
                    {{ __('Forgot your password?') }}
                </a>
            @endif
        </div>

        <div class="flex items-center justify-end pt-2">
            <x-primary-button class="ml-3">
                {{ __('Log in') }}
            </x-primary-button>
        </div>
    </form>
</x-guest-layout>
