<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-slate-800 leading-tight">
            Dashboard
        </h2>
    </x-slot>

    <div class="py-8">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="mb-4 rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-700">{{ session('success') }}</div>
            @endif
            @if(session('error'))
                <div class="mb-4 rounded-lg border border-red-200 bg-red-50 px-4 py-3 text-sm text-red-700">{{ session('error') }}</div>
            @endif

            <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-4">
                @if($role === 'super_admin')
                    <div class="rounded-xl border border-slate-200 bg-white p-4 shadow-sm">
                        <p class="text-xs uppercase text-slate-500">Labs</p>
                        <p class="mt-1 text-2xl font-semibold text-slate-900">{{ $stats['labs'] }}</p>
                    </div>
                @endif
                <div class="rounded-xl border border-slate-200 bg-white p-4 shadow-sm">
                    <p class="text-xs uppercase text-slate-500">Staff</p>
                    <p class="mt-1 text-2xl font-semibold text-slate-900">{{ $stats['staff'] }}</p>
                </div>
                <div class="rounded-xl border border-slate-200 bg-white p-4 shadow-sm">
                    <p class="text-xs uppercase text-slate-500">Patients</p>
                    <p class="mt-1 text-2xl font-semibold text-slate-900">{{ $stats['patients'] }}</p>
                </div>
                <div class="rounded-xl border border-slate-200 bg-white p-4 shadow-sm">
                    <p class="text-xs uppercase text-slate-500">Orders</p>
                    <p class="mt-1 text-2xl font-semibold text-slate-900">{{ $stats['orders_total'] }}</p>
                </div>
                <div class="rounded-xl border border-slate-200 bg-white p-4 shadow-sm">
                    <p class="text-xs uppercase text-slate-500">Pending</p>
                    <p class="mt-1 text-2xl font-semibold text-amber-600">{{ $stats['orders_pending'] }}</p>
                </div>
                <div class="rounded-xl border border-slate-200 bg-white p-4 shadow-sm">
                    <p class="text-xs uppercase text-slate-500">Ready</p>
                    <p class="mt-1 text-2xl font-semibold text-emerald-600">{{ $stats['orders_ready'] }}</p>
                </div>
                <div class="rounded-xl border border-slate-200 bg-white p-4 shadow-sm sm:col-span-2">
                    <p class="text-xs uppercase text-slate-500">Revenue</p>
                    <p class="mt-1 text-2xl font-semibold text-sky-700">{{ number_format($stats['revenue'], 2) }}</p>
                </div>
                <div class="rounded-xl border border-slate-200 bg-white p-4 shadow-sm">
                    <p class="text-xs uppercase text-slate-500">Daily Revenue</p>
                    <p class="mt-1 text-2xl font-semibold text-indigo-700">{{ number_format($stats['revenue_daily'], 2) }}</p>
                </div>
                <div class="rounded-xl border border-slate-200 bg-white p-4 shadow-sm">
                    <p class="text-xs uppercase text-slate-500">Monthly Revenue</p>
                    <p class="mt-1 text-2xl font-semibold text-violet-700">{{ number_format($stats['revenue_monthly'], 2) }}</p>
                </div>
            </div>

            <div class="mt-6 rounded-xl border border-slate-200 bg-white shadow-sm overflow-hidden">
                <div class="border-b border-slate-200 px-4 py-3 flex items-center justify-between">
                    <h3 class="font-semibold text-slate-800">Recent Orders</h3>
                    <a href="{{ route('frontdesk.orders.index') }}" class="text-sm text-sky-700 hover:text-sky-800">View all</a>
                </div>
                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead class="bg-slate-50 text-slate-600">
                            <tr>
                                <th class="px-4 py-2 text-left">Order</th>
                                <th class="px-4 py-2 text-left">Patient</th>
                                <th class="px-4 py-2 text-left">Lab</th>
                                <th class="px-4 py-2 text-left">Status</th>
                                <th class="px-4 py-2 text-left">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($recentOrders as $order)
                                <tr class="border-t border-slate-100">
                                    <td class="px-4 py-2">
                                        <a href="{{ route('frontdesk.orders.show', $order) }}" class="text-sky-700 hover:text-sky-800">{{ $order->order_code }}</a>
                                    </td>
                                    <td class="px-4 py-2">{{ $order->patient->full_name ?? '-' }}</td>
                                    <td class="px-4 py-2">{{ optional($order->lab)->name }} {{ optional($order->lab)->branch_name }}</td>
                                    <td class="px-4 py-2 uppercase text-xs">{{ $order->status }}</td>
                                    <td class="px-4 py-2">{{ number_format((float) $order->total, 2) }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td class="px-4 py-4 text-slate-500" colspan="5">No orders yet.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
