<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Documentation | {{ $brandName ?? config('app.name', 'Lab Result Portal') }}</title>
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=outfit:500,600,700,800|manrope:400,500,600,700&display=swap" rel="stylesheet" />
    <style>
        :root {
            --bg: #f0f3f8;
            --card: #ffffff;
            --line: #dfe5ef;
            --ink: #1e2530;
            --muted: #5b6778;
            --accent: #2453ff;
        }
        * { box-sizing: border-box; }
        body {
            margin: 0;
            font-family: Manrope, sans-serif;
            background: var(--bg);
            color: var(--ink);
        }
        .wrap {
            max-width: 1080px;
            margin: 0 auto;
            padding: 28px 16px 38px;
        }
        .top {
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 10px;
            margin-bottom: 16px;
        }
        .brand {
            display: inline-flex;
            align-items: center;
            gap: 10px;
            font-family: Outfit, sans-serif;
            font-weight: 800;
            text-decoration: none;
            color: var(--ink);
        }
        .logo {
            width: 30px;
            height: 30px;
            border-radius: 8px;
            background: #fff;
            border: 1px solid var(--line);
            overflow: hidden;
            display: grid;
            place-items: center;
        }
        .logo img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }
        .btn {
            text-decoration: none;
            border-radius: 10px;
            padding: 9px 13px;
            border: 1px solid var(--line);
            background: #fff;
            color: var(--ink);
            font-weight: 700;
            font-size: 14px;
        }
        .hero {
            background: linear-gradient(125deg, #2453ff, #1f39b6);
            color: #fff;
            border-radius: 18px;
            padding: 24px 22px;
            margin-bottom: 14px;
        }
        h1, h2, h3 {
            font-family: Outfit, sans-serif;
            margin: 0;
        }
        h1 {
            font-size: clamp(24px, 4vw, 38px);
            line-height: 1.08;
        }
        .hero p {
            margin: 10px 0 0;
            max-width: 760px;
            color: #dbe4ff;
        }
        .grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 12px;
        }
        .card {
            background: var(--card);
            border: 1px solid var(--line);
            border-radius: 14px;
            padding: 16px;
        }
        .card h2 {
            font-size: 20px;
            margin-bottom: 10px;
        }
        .list {
            margin: 0;
            padding-left: 18px;
            color: var(--muted);
            line-height: 1.6;
        }
        .flow {
            display: grid;
            gap: 8px;
        }
        .step {
            background: #f7f9fd;
            border: 1px solid var(--line);
            border-radius: 10px;
            padding: 10px 12px;
        }
        .step strong {
            display: block;
            margin-bottom: 4px;
            font-family: Outfit, sans-serif;
            font-size: 15px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
            font-size: 14px;
        }
        th, td {
            border: 1px solid var(--line);
            padding: 8px 10px;
            text-align: left;
        }
        th {
            background: #f7f9fd;
            font-family: Outfit, sans-serif;
            font-weight: 700;
        }
        .muted {
            color: var(--muted);
        }
        @media (max-width: 860px) {
            .grid { grid-template-columns: 1fr; }
        }
    </style>
</head>
<body>
    <main class="wrap">
        <div class="top">
            <a href="{{ url('/') }}" class="brand">
                <span class="logo">
                    @if (!empty($brandLogoUrl))
                        <img src="{{ $brandLogoUrl }}" alt="{{ $brandName ?? config('app.name', 'Lab Result Portal') }}">
                    @else
                        <span>+</span>
                    @endif
                </span>
                <span>{{ $brandName ?? config('app.name', 'Lab Result Portal') }}</span>
            </a>
            <a href="{{ url('/') }}" class="btn">Back Home</a>
        </div>

        <section class="hero">
            <h1>System Documentation</h1>
            <p>Operational guide for super admin, lab manager, lab staff, frontdesk workflows, patient OTP login, report upload, and support process.</p>
        </section>

        <section class="grid">
            <article class="card">
                <h2>Role Access</h2>
                <ul class="list">
                    <li><strong>Super Admin:</strong> Manages labs, users, categories, tests, pricing, branding, and frontend content.</li>
                    <li><strong>Lab Manager:</strong> Manages lab staff, views OTP logs, oversees daily operations for assigned lab.</li>
                    <li><strong>Lab Staff:</strong> Registers patients, creates orders, records payments, uploads results.</li>
                    <li><strong>Patient:</strong> OTP-only login using email/phone, can view portal and download receipts/results.</li>
                </ul>
            </article>

            <article class="card">
                <h2>Patient OTP Flow</h2>
                <div class="flow">
                    <div class="step">
                        <strong>1. Request OTP</strong>
                        Patient enters registered email or phone on `/patient/login`.
                    </div>
                    <div class="step">
                        <strong>2. Channels</strong>
                        OTP is sent through available channels (email, SMS, WhatsApp).
                    </div>
                    <div class="step">
                        <strong>3. Verify</strong>
                        Patient submits 6-digit OTP on `/patient/login/verify-otp`.
                    </div>
                    <div class="step">
                        <strong>4. Access</strong>
                        Patient opens portal, views orders, downloads result and transaction receipt.
                    </div>
                </div>
            </article>

            <article class="card">
                <h2>Lab Staff Workflow</h2>
                <div class="flow">
                    <div class="step"><strong>1. Register Patient</strong>Create/update patient demographic data.</div>
                    <div class="step"><strong>2. Create Order</strong>Select tests from catalog, apply lab pricing.</div>
                    <div class="step"><strong>3. Receive Payment</strong>Record payment and outstanding balance.</div>
                    <div class="step"><strong>4. Upload Result</strong>Attach result file (watermark applied for patient download).</div>
                    <div class="step"><strong>5. Delivery</strong>Patient receives OTP and accesses result securely.</div>
                </div>
            </article>

            <article class="card">
                <h2>Admin Frontend Settings</h2>
                <ul class="list">
                    <li>Path: <code>/admin/branding</code></li>
                    <li>Edit app name and logo.</li>
                    <li>Edit landing page hero title/subtitle.</li>
                    <li>Edit contact section (email, phone, address).</li>
                    <li>Set official WhatsApp business number.</li>
                    <li>Set social links (Facebook, Instagram, X, LinkedIn).</li>
                </ul>
            </article>

            <article class="card" style="grid-column: 1 / -1;">
                <h2>Demo Accounts (Seed Data)</h2>
                <p class="muted">Use only in development/testing environment.</p>
                <table>
                    <thead>
                        <tr>
                            <th>Role</th>
                            <th>Email</th>
                            <th>Password</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Super Admin</td>
                            <td><code>superadmin@lab.test</code></td>
                            <td><code>SuperAdmin@123</code></td>
                        </tr>
                        <tr>
                            <td>Lab Manager</td>
                            <td><code>manager@lab.test</code></td>
                            <td><code>LabManager@123</code></td>
                        </tr>
                        <tr>
                            <td>Lab Staff</td>
                            <td><code>staff@lab.test</code></td>
                            <td><code>LabStaff@123</code></td>
                        </tr>
                    </tbody>
                </table>
            </article>
        </section>
    </main>
</body>
</html>
