<x-app-layout>
    <x-slot name="header">
        <h2 class="text-xl font-semibold text-slate-800">Create Order for {{ $patient->full_name }}</h2>
    </x-slot>

    <div class="py-6">
        <div class="mx-auto max-w-5xl sm:px-6 lg:px-8">
            <div class="rounded-xl border border-slate-200 bg-white p-5 shadow-sm">
                <form method="POST" action="{{ route('frontdesk.patients.orders.store', $patient) }}" class="space-y-4" x-data="{ rows: [{ id: '', qty: 1 }] }">
                    @csrf

                    <div class="grid gap-4 md:grid-cols-3">
                        <div>
                            <label class="block text-sm font-medium text-slate-700">Patient</label>
                            <input type="text" value="{{ $patient->full_name }}" disabled class="mt-1 w-full rounded-lg border-slate-300 bg-slate-100">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-slate-700">Lab</label>
                            <input type="text" value="{{ $lab->name }} {{ $lab->branch_name }}" disabled class="mt-1 w-full rounded-lg border-slate-300 bg-slate-100">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-slate-700">Discount</label>
                            <input type="number" step="0.01" min="0" name="discount" value="{{ old('discount', 0) }}" class="mt-1 w-full rounded-lg border-slate-300">
                            @error('discount')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>

                    <div class="rounded-lg border border-slate-200">
                        <div class="border-b border-slate-200 px-4 py-3 flex items-center justify-between">
                            <h3 class="font-semibold text-slate-800">Select tests</h3>
                            <button type="button" class="rounded-lg border border-slate-300 px-3 py-1 text-xs font-semibold" @click="rows.push({ id: '', qty: 1 })">Add row</button>
                        </div>

                        <div class="p-4 space-y-3">
                            <template x-for="(row, index) in rows" :key="index">
                                <div class="grid gap-3 md:grid-cols-12">
                                    <div class="md:col-span-8">
                                        <select :name="'tests['+index+'][test_id]'" x-model="row.id" class="w-full rounded-lg border-slate-300" required>
                                            <option value="">Select a test</option>
                                            @foreach($tests as $test)
                                                <option value="{{ $test->id }}">{{ $test->code }} - {{ $test->name }} ({{ number_format((float) ($overrides[$test->id]->price ?? $test->default_price), 2) }})</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="md:col-span-3">
                                        <input type="number" min="1" :name="'tests['+index+'][qty]'" x-model="row.qty" class="w-full rounded-lg border-slate-300" required>
                                    </div>
                                    <div class="md:col-span-1">
                                        <button type="button" class="w-full rounded-lg border border-red-200 bg-red-50 px-2 py-2 text-xs font-semibold text-red-700" @click="rows.splice(index, 1)" x-show="rows.length > 1">x</button>
                                    </div>
                                </div>
                            </template>
                        </div>
                    </div>

                    @if($errors->any())
                        <div class="rounded-lg border border-red-200 bg-red-50 px-4 py-3 text-sm text-red-700">
                            <ul class="list-disc pl-5">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <div class="flex items-center justify-end gap-2">
                        <a href="{{ route('frontdesk.patients.show', $patient) }}" class="rounded-lg border border-slate-300 px-4 py-2 text-sm font-medium text-slate-700">Cancel</a>
                        <button type="submit" class="rounded-lg bg-sky-600 px-4 py-2 text-sm font-semibold text-white hover:bg-sky-700">Create order</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>
