<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 11px; }
        h2 { margin: 0 0 12px; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ddd; padding: 6px; text-align: left; }
        th { background: #f6f6f6; }
    </style>
</head>
<body>
    <h2>Orders Export</h2>
    <table>
        <thead>
            <tr>
                <th>Code</th>
                <th>Lab</th>
                <th>Patient</th>
                <th>Status</th>
                <th>Total</th>
                <th>Paid</th>
                <th>Balance</th>
                <th>Date</th>
            </tr>
        </thead>
        <tbody>
            @foreach($orders as $order)
                <tr>
                    <td>{{ $order->order_code }}</td>
                    <td>{{ optional($order->lab)->name }} {{ optional($order->lab)->branch_name }}</td>
                    <td>{{ optional($order->patient)->full_name }}</td>
                    <td>{{ strtoupper($order->status) }}</td>
                    <td>{{ number_format((float) $order->total, 2) }}</td>
                    <td>{{ number_format((float) $order->paid, 2) }}</td>
                    <td>{{ number_format((float) $order->balance, 2) }}</td>
                    <td>{{ optional($order->created_at)->format('Y-m-d H:i') }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
