<x-app-layout>
    <x-slot name="header">
        <h2 class="text-xl font-semibold text-slate-800">Orders</h2>
    </x-slot>

    <div class="py-6">
        <div class="mx-auto max-w-7xl space-y-4 sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-700">{{ session('success') }}</div>
            @endif

            <div class="rounded-xl border border-slate-200 bg-white p-4 shadow-sm">
                <form class="grid gap-3 md:grid-cols-5" method="GET" action="{{ route('frontdesk.orders.index') }}">
                    <input type="text" name="q" value="{{ request('q') }}" placeholder="Search by code or patient" class="md:col-span-2 rounded-lg border-slate-300">
                    <select name="status" class="rounded-lg border-slate-300">
                        <option value="">All statuses</option>
                        @foreach(['draft','pending','paid','ready','delivered','cancelled'] as $status)
                            <option value="{{ $status }}" @selected(request('status') === $status)>{{ ucfirst($status) }}</option>
                        @endforeach
                    </select>
                    <button type="submit" class="rounded-lg border border-slate-300 px-4 py-2 text-sm font-medium text-slate-700">Filter</button>
                    <div class="flex items-center gap-2 md:justify-end">
                        <a href="{{ route('frontdesk.orders.export.csv', request()->query()) }}" class="rounded-lg border border-slate-300 px-3 py-2 text-xs font-semibold">CSV</a>
                        <a href="{{ route('frontdesk.orders.export.pdf', request()->query()) }}" class="rounded-lg border border-slate-300 px-3 py-2 text-xs font-semibold">PDF</a>
                        <a href="{{ route('frontdesk.orders.print', request()->query()) }}" target="_blank" class="rounded-lg border border-slate-300 px-3 py-2 text-xs font-semibold">Print</a>
                    </div>
                </form>
            </div>

            <div class="rounded-xl border border-slate-200 bg-white shadow-sm overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead class="bg-slate-50 text-slate-600">
                            <tr>
                                <th class="px-4 py-2 text-left">Code</th>
                                <th class="px-4 py-2 text-left">Patient</th>
                                <th class="px-4 py-2 text-left">Lab</th>
                                <th class="px-4 py-2 text-left">Status</th>
                                <th class="px-4 py-2 text-left">Total</th>
                                <th class="px-4 py-2 text-left">Balance</th>
                                <th class="px-4 py-2 text-right">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($orders as $order)
                                <tr class="border-t border-slate-100">
                                    <td class="px-4 py-2 font-medium">{{ $order->order_code }}</td>
                                    <td class="px-4 py-2">{{ $order->patient->full_name ?? '-' }}</td>
                                    <td class="px-4 py-2">{{ optional($order->lab)->name }} {{ optional($order->lab)->branch_name }}</td>
                                    <td class="px-4 py-2 uppercase text-xs">{{ $order->status }}</td>
                                    <td class="px-4 py-2">{{ number_format((float) $order->total, 2) }}</td>
                                    <td class="px-4 py-2">{{ number_format((float) $order->balance, 2) }}</td>
                                    <td class="px-4 py-2 text-right">
                                        <a href="{{ route('frontdesk.orders.show', $order) }}" class="text-sky-700 hover:text-sky-800 text-xs font-semibold">Open</a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="px-4 py-6 text-center text-slate-500">No orders found.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="border-t border-slate-200 px-4 py-3">{{ $orders->links() }}</div>
            </div>
        </div>
    </div>
</x-app-layout>
