<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>Orders Print</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        table { width: 100%; border-collapse: collapse; font-size: 12px; }
        th, td { border: 1px solid #ddd; padding: 6px; text-align: left; }
        th { background: #f4f4f4; }
    </style>
</head>
<body onload="window.print()">
    <h3>Orders List</h3>
    <table>
        <thead>
            <tr>
                <th>Code</th>
                <th>Lab</th>
                <th>Patient</th>
                <th>Status</th>
                <th>Total</th>
                <th>Paid</th>
                <th>Balance</th>
                <th>Date</th>
            </tr>
        </thead>
        <tbody>
            @foreach($orders as $order)
                <tr>
                    <td>{{ $order->order_code }}</td>
                    <td>{{ optional($order->lab)->name }} {{ optional($order->lab)->branch_name }}</td>
                    <td>{{ optional($order->patient)->full_name }}</td>
                    <td>{{ strtoupper($order->status) }}</td>
                    <td>{{ number_format((float) $order->total, 2) }}</td>
                    <td>{{ number_format((float) $order->paid, 2) }}</td>
                    <td>{{ number_format((float) $order->balance, 2) }}</td>
                    <td>{{ optional($order->created_at)->format('Y-m-d H:i') }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
