<x-app-layout>
    <x-slot name="header">
        <div class="flex flex-wrap items-center justify-between gap-3">
            <h2 class="text-xl font-semibold text-slate-800">Order {{ $order->order_code }}</h2>
            <a href="{{ route('frontdesk.orders.index') }}" class="rounded-lg border border-slate-300 px-3 py-2 text-sm font-medium text-slate-700">Back to orders</a>
        </div>
    </x-slot>

    <div class="py-6">
        <div class="mx-auto max-w-7xl space-y-4 sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-700">{{ session('success') }}</div>
            @endif

            @if($errors->any())
                <div class="rounded-lg border border-red-200 bg-red-50 px-4 py-3 text-sm text-red-700">
                    <ul class="list-disc pl-5">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="rounded-xl border border-slate-200 bg-white p-5 shadow-sm">
                <div class="grid gap-4 md:grid-cols-5 text-sm">
                    <div><p class="text-slate-500">Patient</p><p class="font-medium">{{ $order->patient->full_name }}</p></div>
                    <div><p class="text-slate-500">Lab</p><p class="font-medium">{{ optional($order->lab)->name }} {{ optional($order->lab)->branch_name }}</p></div>
                    <div><p class="text-slate-500">Status</p><p class="font-medium uppercase">{{ $order->status }}</p></div>
                    <div><p class="text-slate-500">Total</p><p class="font-medium">{{ number_format((float) $order->total, 2) }}</p></div>
                    <div><p class="text-slate-500">Balance</p><p class="font-medium">{{ number_format((float) $order->balance, 2) }}</p></div>
                </div>

                <div class="mt-4 grid gap-3 md:grid-cols-4">
                    <form method="POST" action="{{ route('frontdesk.orders.update', $order) }}" class="md:col-span-3 grid gap-3 md:grid-cols-3">
                        @csrf
                        @method('PUT')
                        <div>
                            <label class="block text-xs font-medium text-slate-600">Status</label>
                            <select name="status" class="mt-1 w-full rounded-lg border-slate-300">
                                @foreach(['draft','pending','paid','ready','delivered','cancelled'] as $status)
                                    <option value="{{ $status }}" @selected($order->status === $status)>{{ ucfirst($status) }}</option>
                                @endforeach
                            </select>
                            @error('status')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                        <div>
                            <label class="block text-xs font-medium text-slate-600">Discount</label>
                            <input type="number" step="0.01" min="0" name="discount" value="{{ $order->discount }}" class="mt-1 w-full rounded-lg border-slate-300">
                            @error('discount')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                        <div class="flex items-end">
                            <button type="submit" class="w-full rounded-lg bg-sky-600 px-4 py-2 text-sm font-semibold text-white hover:bg-sky-700">Update order</button>
                        </div>
                    </form>
                    <form method="POST" action="{{ route('frontdesk.orders.destroy', $order) }}" onsubmit="return confirm('Delete this order?')" class="flex items-end">
                        @csrf
                        @method('DELETE')
                        <button class="w-full rounded-lg border border-red-200 bg-red-50 px-4 py-2 text-sm font-semibold text-red-700">Delete</button>
                    </form>
                </div>
            </div>

            <div class="grid gap-4 lg:grid-cols-3">
                <section class="rounded-xl border border-slate-200 bg-white shadow-sm overflow-hidden lg:col-span-2">
                    <div class="border-b border-slate-200 px-4 py-3 flex items-center justify-between">
                        <h3 class="font-semibold text-slate-800">Test Items</h3>
                    </div>
                    <div class="overflow-x-auto">
                        <table class="min-w-full text-sm">
                            <thead class="bg-slate-50 text-slate-600">
                                <tr>
                                    <th class="px-4 py-2 text-left">Test</th>
                                    <th class="px-4 py-2 text-left">Qty</th>
                                    <th class="px-4 py-2 text-left">Price</th>
                                    <th class="px-4 py-2 text-left">Total</th>
                                    <th class="px-4 py-2 text-right">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($order->items as $item)
                                    <tr class="border-t border-slate-100">
                                        <td class="px-4 py-2">{{ $item->test->name ?? '-' }}</td>
                                        <td class="px-4 py-2">{{ $item->qty }}</td>
                                        <td class="px-4 py-2">{{ number_format((float) $item->price, 2) }}</td>
                                        <td class="px-4 py-2">{{ number_format((float) $item->line_total, 2) }}</td>
                                        <td class="px-4 py-2 text-right">
                                            <form method="POST" action="{{ route('frontdesk.orders.items.destroy', [$order, $item]) }}" onsubmit="return confirm('Remove item?')">
                                                @csrf
                                                @method('DELETE')
                                                <button class="text-xs font-semibold text-red-700">Remove</button>
                                            </form>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="px-4 py-4 text-slate-500">No tests added yet.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="border-t border-slate-200 p-4">
                        <form method="POST" action="{{ route('frontdesk.orders.items.store', $order) }}" class="grid gap-2 md:grid-cols-12">
                            @csrf
                            <select name="test_id" class="md:col-span-8 rounded-lg border-slate-300" required>
                                <option value="">Select test</option>
                                @foreach($tests as $test)
                                    <option value="{{ $test->id }}">{{ $test->code }} - {{ $test->name }} ({{ number_format((float) ($overrides[$test->id]->price ?? $test->default_price), 2) }})</option>
                                @endforeach
                            </select>
                            <input type="number" name="qty" min="1" value="1" class="md:col-span-2 rounded-lg border-slate-300" required>
                            <button class="md:col-span-2 rounded-lg bg-slate-800 px-3 py-2 text-sm font-semibold text-white hover:bg-slate-900">Add item</button>
                        </form>
                        @error('test_id')
                            <p class="mt-2 text-xs text-red-600">{{ $message }}</p>
                        @enderror
                        @error('qty')
                            <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                        @enderror
                    </div>
                </section>

                <section class="space-y-4">
                    <div class="rounded-xl border border-slate-200 bg-white p-4 shadow-sm">
                        <h3 class="font-semibold text-slate-800">Record Payment</h3>
                        <form method="POST" action="{{ route('frontdesk.orders.payments.store', $order) }}" class="mt-3 space-y-2">
                            @csrf
                            <input type="number" step="0.01" min="0.01" name="amount" value="{{ old('amount') }}" placeholder="Amount" class="w-full rounded-lg border-slate-300" required>
                            @error('amount')
                                <p class="text-xs text-red-600">{{ $message }}</p>
                            @enderror
                            <select name="method" class="w-full rounded-lg border-slate-300" required>
                                @foreach(['cash','transfer','pos','card','online','other'] as $method)
                                    <option value="{{ $method }}" @selected(old('method') === $method)>{{ strtoupper($method) }}</option>
                                @endforeach
                            </select>
                            @error('method')
                                <p class="text-xs text-red-600">{{ $message }}</p>
                            @enderror
                            <input type="text" name="reference" value="{{ old('reference') }}" placeholder="Reference (optional)" class="w-full rounded-lg border-slate-300">
                            @error('reference')
                                <p class="text-xs text-red-600">{{ $message }}</p>
                            @enderror
                            <button class="w-full rounded-lg bg-emerald-600 px-3 py-2 text-sm font-semibold text-white hover:bg-emerald-700">Save payment</button>
                        </form>

                        <div class="mt-3 border-t border-slate-200 pt-3 space-y-2">
                            @forelse($order->payments as $payment)
                                <div class="flex items-center justify-between text-xs">
                                    <span>{{ strtoupper($payment->method) }} {{ number_format((float) $payment->amount, 2) }}</span>
                                    <form method="POST" action="{{ route('frontdesk.orders.payments.destroy', [$order, $payment]) }}" onsubmit="return confirm('Delete payment?')">
                                        @csrf
                                        @method('DELETE')
                                        <button class="text-red-700">Delete</button>
                                    </form>
                                </div>
                            @empty
                                <p class="text-xs text-slate-500">No payments yet.</p>
                            @endforelse
                        </div>
                    </div>

                    <div class="rounded-xl border border-slate-200 bg-white p-4 shadow-sm">
                        <h3 class="font-semibold text-slate-800">Upload Result</h3>
                        <p class="mt-1 text-xs text-slate-500">Uploaded file will be watermarked automatically.</p>
                        <form method="POST" action="{{ route('frontdesk.orders.results.store', $order) }}" enctype="multipart/form-data" class="mt-3 space-y-2">
                            @csrf
                            <input type="file" name="result_file" class="w-full rounded-lg border-slate-300" required>
                            @error('result_file')
                                <p class="text-xs text-red-600">{{ $message }}</p>
                            @enderror
                            <button class="w-full rounded-lg bg-sky-600 px-3 py-2 text-sm font-semibold text-white hover:bg-sky-700">Upload result</button>
                        </form>

                        <div class="mt-3 border-t border-slate-200 pt-3 space-y-2">
                            @forelse($order->results as $result)
                                <div class="text-xs">
                                    <div class="flex items-center justify-between">
                                        <a href="{{ route('frontdesk.orders.results.download', [$order, $result]) }}" class="text-sky-700 hover:text-sky-800">Version {{ $result->version }} download</a>
                                        <form method="POST" action="{{ route('frontdesk.orders.results.destroy', [$order, $result]) }}" onsubmit="return confirm('Delete result?')">
                                            @csrf
                                            @method('DELETE')
                                            <button class="text-red-700">Delete</button>
                                        </form>
                                    </div>
                                    <p class="text-slate-500">{{ optional($result->created_at)->format('Y-m-d H:i') }}</p>
                                </div>
                            @empty
                                <p class="text-xs text-slate-500">No result uploaded yet.</p>
                            @endforelse
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
</x-app-layout>
