<x-app-layout>
    <x-slot name="header">
        <h2 class="text-xl font-semibold text-slate-800">Patient OTP Log</h2>
    </x-slot>

    <div class="py-6">
        <div class="mx-auto max-w-7xl space-y-4 sm:px-6 lg:px-8">
            <div class="rounded-xl border border-amber-200 bg-amber-50 px-4 py-3 text-sm text-amber-800">
                Use this log only for delivery fallback when patient did not receive OTP. OTPs are time-limited and should be shared only after patient identity confirmation.
            </div>

            <div class="rounded-xl border border-slate-200 bg-white p-4 shadow-sm">
                <form method="GET" action="{{ route('frontdesk.otps.index') }}" class="grid gap-3 md:grid-cols-4">
                    <input type="text" name="q" value="{{ request('q') }}" placeholder="Search patient name/email/phone/identifier" class="md:col-span-2 rounded-lg border-slate-300">
                    <button type="submit" class="rounded-lg border border-slate-300 px-4 py-2 text-sm font-medium text-slate-700">Filter</button>
                    <a href="{{ route('frontdesk.otps.index') }}" class="rounded-lg border border-slate-300 px-4 py-2 text-sm font-medium text-slate-700 text-center">Reset</a>
                </form>
            </div>

            <div class="rounded-xl border border-slate-200 bg-white shadow-sm overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead class="bg-slate-50 text-slate-600">
                            <tr>
                                <th class="px-4 py-2 text-left">Patient</th>
                                <th class="px-4 py-2 text-left">Channels</th>
                                <th class="px-4 py-2 text-left">OTP</th>
                                <th class="px-4 py-2 text-left">Status</th>
                                <th class="px-4 py-2 text-left">Attempts</th>
                                <th class="px-4 py-2 text-left">Sent</th>
                                <th class="px-4 py-2 text-left">Expires</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($otps as $otp)
                                @php
                                    $status = 'active';
                                    if ($otp->consumed_at) {
                                        $status = 'used';
                                    } elseif ($otp->expires_at && $otp->expires_at->isPast()) {
                                        $status = 'expired';
                                    } elseif ($otp->locked_until && $otp->locked_until->isFuture()) {
                                        $status = 'locked';
                                    }
                                @endphp
                                <tr class="border-t border-slate-100">
                                    <td class="px-4 py-2">
                                        <div class="font-medium text-slate-800">{{ $otp->patient?->full_name ?: 'Unknown patient' }}</div>
                                        <div class="text-xs text-slate-500">{{ $otp->patient?->email ?: '-' }} | {{ $otp->patient?->phone ?: '-' }}</div>
                                    </td>
                                    <td class="px-4 py-2 uppercase text-xs">{{ $otp->channel }}</td>
                                    <td class="px-4 py-2">
                                        <span class="inline-flex rounded-md bg-slate-900 px-2 py-1 font-mono text-xs font-semibold text-white">{{ $otp->plain_code ?: 'n/a' }}</span>
                                    </td>
                                    <td class="px-4 py-2">
                                        <span class="inline-flex rounded-full px-2 py-1 text-xs font-semibold
                                            @if($status === 'active') bg-emerald-100 text-emerald-700 @endif
                                            @if($status === 'used') bg-sky-100 text-sky-700 @endif
                                            @if($status === 'expired') bg-slate-200 text-slate-700 @endif
                                            @if($status === 'locked') bg-red-100 text-red-700 @endif
                                        ">{{ strtoupper($status) }}</span>
                                    </td>
                                    <td class="px-4 py-2">{{ $otp->attempts }}</td>
                                    <td class="px-4 py-2">{{ optional($otp->created_at)->format('Y-m-d H:i:s') }}</td>
                                    <td class="px-4 py-2">{{ optional($otp->expires_at)->format('Y-m-d H:i:s') }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="px-4 py-6 text-center text-slate-500">No OTP records found.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="border-t border-slate-200 px-4 py-3">{{ $otps->links() }}</div>
            </div>
        </div>
    </div>
</x-app-layout>
