@php($editingPatient = $patient ?? null)

<div class="grid gap-4 md:grid-cols-2">
    @if(($canSelectLab ?? false) && isset($labs))
        <div class="md:col-span-2">
            <label class="block text-sm font-medium text-slate-700">Lab</label>
            <select name="lab_id" class="mt-1 w-full rounded-lg border-slate-300" required>
                <option value="">Select lab</option>
                @foreach($labs as $lab)
                    <option value="{{ $lab->id }}" @selected((string) old('lab_id', optional($editingPatient)->lab_id) === (string) $lab->id)>
                        {{ $lab->name }}{{ $lab->branch_name ? ' - '.$lab->branch_name : '' }}
                    </option>
                @endforeach
            </select>
            @error('lab_id') <p class="mt-1 text-xs text-red-600">{{ $message }}</p> @enderror
        </div>
    @endif

    <div class="md:col-span-2">
        <label class="block text-sm font-medium text-slate-700">Full name</label>
        <input type="text" name="full_name" value="{{ old('full_name', optional($editingPatient)->full_name) }}" class="mt-1 w-full rounded-lg border-slate-300" required>
        @error('full_name') <p class="mt-1 text-xs text-red-600">{{ $message }}</p> @enderror
    </div>

    <div>
        <label class="block text-sm font-medium text-slate-700">Email</label>
        <input type="email" name="email" value="{{ old('email', optional($editingPatient)->email) }}" class="mt-1 w-full rounded-lg border-slate-300">
        @error('email') <p class="mt-1 text-xs text-red-600">{{ $message }}</p> @enderror
    </div>

    <div>
        <label class="block text-sm font-medium text-slate-700">Phone</label>
        <input type="text" name="phone" value="{{ old('phone', optional($editingPatient)->phone) }}" class="mt-1 w-full rounded-lg border-slate-300">
        @error('phone') <p class="mt-1 text-xs text-red-600">{{ $message }}</p> @enderror
    </div>

    <div>
        <label class="block text-sm font-medium text-slate-700">Date of birth</label>
        <input type="date" name="dob" value="{{ old('dob', optional(optional($editingPatient)->dob)->format('Y-m-d')) }}" class="mt-1 w-full rounded-lg border-slate-300">
        @error('dob') <p class="mt-1 text-xs text-red-600">{{ $message }}</p> @enderror
    </div>

    <div>
        <label class="block text-sm font-medium text-slate-700">Gender</label>
        <select name="gender" class="mt-1 w-full rounded-lg border-slate-300">
            <option value="">Select</option>
            @foreach(['male' => 'Male', 'female' => 'Female', 'other' => 'Other'] as $value => $label)
                <option value="{{ $value }}" @selected(old('gender', optional($editingPatient)->gender) === $value)>{{ $label }}</option>
            @endforeach
        </select>
        @error('gender') <p class="mt-1 text-xs text-red-600">{{ $message }}</p> @enderror
    </div>
</div>
