<x-app-layout>
    <x-slot name="header">
        <h2 class="text-xl font-semibold text-slate-800">Edit Patient</h2>
    </x-slot>

    <div class="py-6">
        <div class="mx-auto max-w-3xl sm:px-6 lg:px-8">
            <div class="rounded-xl border border-slate-200 bg-white p-5 shadow-sm">
                <form method="POST" action="{{ route('frontdesk.patients.update', $patient) }}" class="space-y-4">
                    @csrf
                    @method('PUT')
                    @include('frontdesk.patients._form', ['patient' => $patient])
                    <div class="flex items-center justify-end gap-2">
                        <a href="{{ route('frontdesk.patients.show', $patient) }}" class="rounded-lg border border-slate-300 px-4 py-2 text-sm font-medium text-slate-700">Back</a>
                        <button type="submit" class="rounded-lg bg-sky-600 px-4 py-2 text-sm font-semibold text-white hover:bg-sky-700">Update patient</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>
