<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        h2 { margin: 0 0 12px; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ddd; padding: 6px; text-align: left; }
        th { background: #f6f6f6; }
    </style>
</head>
<body>
    <h2>Patients Export</h2>
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Lab</th>
                <th>Email</th>
                <th>Phone</th>
                <th>DOB</th>
                <th>Gender</th>
            </tr>
        </thead>
        <tbody>
            @foreach($patients as $patient)
                <tr>
                    <td>{{ $patient->id }}</td>
                    <td>{{ $patient->full_name }}</td>
                    <td>{{ optional($patient->lab)->name }} {{ optional($patient->lab)->branch_name }}</td>
                    <td>{{ $patient->email }}</td>
                    <td>{{ $patient->phone }}</td>
                    <td>{{ optional($patient->dob)->format('Y-m-d') }}</td>
                    <td>{{ $patient->gender }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
