<x-app-layout>
    <x-slot name="header">
        <div class="flex flex-wrap items-center justify-between gap-3">
            <h2 class="text-xl font-semibold text-slate-800">Patient History: {{ $patient->full_name }}</h2>
            <a href="{{ route('frontdesk.patients.show', $patient) }}" class="rounded-lg border border-slate-300 px-4 py-2 text-sm font-medium text-slate-700">Back to profile</a>
        </div>
    </x-slot>

    <div class="py-6">
        <div class="mx-auto max-w-7xl space-y-4 sm:px-6 lg:px-8">
            <div class="rounded-xl border border-slate-200 bg-white p-5 shadow-sm">
                <h3 class="font-semibold text-slate-800">Patient Details</h3>
                <div class="mt-3 grid gap-4 md:grid-cols-5 text-sm">
                    <div><p class="text-slate-500">Full Name</p><p class="font-medium">{{ $patient->full_name }}</p></div>
                    <div><p class="text-slate-500">Email</p><p class="font-medium">{{ $patient->email ?: '-' }}</p></div>
                    <div><p class="text-slate-500">Phone</p><p class="font-medium">{{ $patient->phone ?: '-' }}</p></div>
                    <div><p class="text-slate-500">Gender</p><p class="font-medium">{{ ucfirst($patient->gender ?: '-') }}</p></div>
                    <div><p class="text-slate-500">DOB</p><p class="font-medium">{{ optional($patient->dob)->format('Y-m-d') ?: '-' }}</p></div>
                </div>
            </div>

            <div class="rounded-xl border border-slate-200 bg-white shadow-sm overflow-hidden">
                <div class="border-b border-slate-200 px-4 py-3">
                    <h3 class="font-semibold text-slate-800">Order History</h3>
                </div>
                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead class="bg-slate-50 text-slate-600">
                            <tr>
                                <th class="px-4 py-2 text-left">Order</th>
                                <th class="px-4 py-2 text-left">Lab</th>
                                <th class="px-4 py-2 text-left">Status</th>
                                <th class="px-4 py-2 text-left">Total</th>
                                <th class="px-4 py-2 text-left">Paid</th>
                                <th class="px-4 py-2 text-left">Balance</th>
                                <th class="px-4 py-2 text-left">Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($orders as $order)
                                <tr class="border-t border-slate-100">
                                    <td class="px-4 py-2 font-medium">
                                        <a href="{{ route('frontdesk.orders.show', $order) }}" class="text-sky-700 hover:text-sky-800">{{ $order->order_code }}</a>
                                    </td>
                                    <td class="px-4 py-2">{{ optional($order->lab)->name }} {{ optional($order->lab)->branch_name }}</td>
                                    <td class="px-4 py-2 uppercase text-xs">{{ $order->status }}</td>
                                    <td class="px-4 py-2">{{ number_format((float) $order->total, 2) }}</td>
                                    <td class="px-4 py-2">{{ number_format((float) $order->paid, 2) }}</td>
                                    <td class="px-4 py-2">{{ number_format((float) $order->balance, 2) }}</td>
                                    <td class="px-4 py-2">{{ optional($order->created_at)->format('Y-m-d H:i') }}</td>
                                </tr>
                            @empty
                                <tr><td colspan="7" class="px-4 py-5 text-slate-500">No orders found.</td></tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="border-t border-slate-200 px-4 py-3">{{ $orders->links() }}</div>
            </div>

            <div class="grid gap-4 lg:grid-cols-2">
                <div class="rounded-xl border border-slate-200 bg-white shadow-sm overflow-hidden">
                    <div class="border-b border-slate-200 px-4 py-3">
                        <h3 class="font-semibold text-slate-800">Payment History</h3>
                    </div>
                    <div class="overflow-x-auto">
                        <table class="min-w-full text-sm">
                            <thead class="bg-slate-50 text-slate-600">
                                <tr>
                                    <th class="px-4 py-2 text-left">Order</th>
                                    <th class="px-4 py-2 text-left">Amount</th>
                                    <th class="px-4 py-2 text-left">Method</th>
                                    <th class="px-4 py-2 text-left">Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($payments as $payment)
                                    <tr class="border-t border-slate-100">
                                        <td class="px-4 py-2">{{ $payment->order_code }}</td>
                                        <td class="px-4 py-2">{{ number_format((float) $payment->amount, 2) }}</td>
                                        <td class="px-4 py-2 uppercase text-xs">{{ $payment->method }}</td>
                                        <td class="px-4 py-2">{{ optional($payment->paid_at ?? $payment->created_at)->format('Y-m-d H:i') }}</td>
                                    </tr>
                                @empty
                                    <tr><td colspan="4" class="px-4 py-5 text-slate-500">No payments found.</td></tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="border-t border-slate-200 px-4 py-3">{{ $payments->links() }}</div>
                </div>

                <div class="rounded-xl border border-slate-200 bg-white shadow-sm overflow-hidden">
                    <div class="border-b border-slate-200 px-4 py-3">
                        <h3 class="font-semibold text-slate-800">Result History</h3>
                    </div>
                    <div class="overflow-x-auto">
                        <table class="min-w-full text-sm">
                            <thead class="bg-slate-50 text-slate-600">
                                <tr>
                                    <th class="px-4 py-2 text-left">Order</th>
                                    <th class="px-4 py-2 text-left">Version</th>
                                    <th class="px-4 py-2 text-left">Uploaded</th>
                                    <th class="px-4 py-2 text-left">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($results as $result)
                                    <tr class="border-t border-slate-100">
                                        <td class="px-4 py-2">{{ $result->order_code }}</td>
                                        <td class="px-4 py-2">{{ $result->version }}</td>
                                        <td class="px-4 py-2">{{ optional($result->created_at)->format('Y-m-d H:i') }}</td>
                                        <td class="px-4 py-2">
                                            <a href="{{ route('frontdesk.orders.results.download', [$result->order_id, $result->id]) }}" class="text-sky-700 hover:text-sky-800">Download</a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr><td colspan="4" class="px-4 py-5 text-slate-500">No results found.</td></tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="border-t border-slate-200 px-4 py-3">{{ $results->links() }}</div>
                </div>
            </div>

            <div class="rounded-xl border border-slate-200 bg-white shadow-sm overflow-hidden">
                <div class="border-b border-slate-200 px-4 py-3">
                    <h3 class="font-semibold text-slate-800">OTP History</h3>
                </div>
                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead class="bg-slate-50 text-slate-600">
                            <tr>
                                <th class="px-4 py-2 text-left">OTP</th>
                                <th class="px-4 py-2 text-left">Channel</th>
                                <th class="px-4 py-2 text-left">Attempts</th>
                                <th class="px-4 py-2 text-left">Consumed</th>
                                <th class="px-4 py-2 text-left">Expires</th>
                                <th class="px-4 py-2 text-left">Sent</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($otpHistory as $otp)
                                <tr class="border-t border-slate-100">
                                    <td class="px-4 py-2"><span class="inline-flex rounded bg-slate-900 px-2 py-1 text-xs font-mono text-white">{{ $otp->plain_code ?: 'n/a' }}</span></td>
                                    <td class="px-4 py-2 uppercase text-xs">{{ $otp->channel }}</td>
                                    <td class="px-4 py-2">{{ $otp->attempts }}</td>
                                    <td class="px-4 py-2">{{ optional($otp->consumed_at)->format('Y-m-d H:i:s') ?: '-' }}</td>
                                    <td class="px-4 py-2">{{ optional($otp->expires_at)->format('Y-m-d H:i:s') ?: '-' }}</td>
                                    <td class="px-4 py-2">{{ optional($otp->created_at)->format('Y-m-d H:i:s') }}</td>
                                </tr>
                            @empty
                                <tr><td colspan="6" class="px-4 py-5 text-slate-500">No OTP history found.</td></tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="border-t border-slate-200 px-4 py-3">{{ $otpHistory->links() }}</div>
            </div>
        </div>
    </div>
</x-app-layout>
