<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-3">
            <h2 class="text-xl font-semibold text-slate-800">Patients</h2>
            <a href="{{ route('frontdesk.patients.create') }}" class="rounded-lg bg-sky-600 px-4 py-2 text-sm font-semibold text-white hover:bg-sky-700">New patient</a>
        </div>
    </x-slot>

    <div class="py-6">
        <div class="mx-auto max-w-7xl space-y-4 sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-700">{{ session('success') }}</div>
            @endif

            <div class="rounded-xl border border-slate-200 bg-white p-4 shadow-sm">
                <form class="grid gap-3 md:grid-cols-4" method="GET" action="{{ route('frontdesk.patients.index') }}">
                    <input type="text" name="q" value="{{ request('q') }}" placeholder="Search name/email/phone" class="md:col-span-2 rounded-lg border-slate-300">
                    <button type="submit" class="rounded-lg border border-slate-300 px-4 py-2 text-sm font-medium text-slate-700">Filter</button>
                    <div class="flex items-center gap-2 md:justify-end">
                        <a href="{{ route('frontdesk.patients.export.csv', request()->query()) }}" class="rounded-lg border border-slate-300 px-3 py-2 text-xs font-semibold">CSV</a>
                        <a href="{{ route('frontdesk.patients.export.pdf', request()->query()) }}" class="rounded-lg border border-slate-300 px-3 py-2 text-xs font-semibold">PDF</a>
                        <a href="{{ route('frontdesk.patients.print', request()->query()) }}" target="_blank" class="rounded-lg border border-slate-300 px-3 py-2 text-xs font-semibold">Print</a>
                    </div>
                </form>
            </div>

            <div class="rounded-xl border border-slate-200 bg-white shadow-sm overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead class="bg-slate-50 text-slate-600">
                            <tr>
                                <th class="px-4 py-2 text-left">Name</th>
                                <th class="px-4 py-2 text-left">Lab</th>
                                <th class="px-4 py-2 text-left">Email</th>
                                <th class="px-4 py-2 text-left">Phone</th>
                                <th class="px-4 py-2 text-left">Gender</th>
                                <th class="px-4 py-2 text-left">DOB</th>
                                <th class="px-4 py-2 text-right">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($patients as $patient)
                                <tr class="border-t border-slate-100">
                                    <td class="px-4 py-2 font-medium text-slate-800">{{ $patient->full_name }}</td>
                                    <td class="px-4 py-2">{{ optional($patient->lab)->name }} {{ optional($patient->lab)->branch_name }}</td>
                                    <td class="px-4 py-2">{{ $patient->email ?: '-' }}</td>
                                    <td class="px-4 py-2">{{ $patient->phone ?: '-' }}</td>
                                    <td class="px-4 py-2">{{ ucfirst($patient->gender ?: '-') }}</td>
                                    <td class="px-4 py-2">{{ optional($patient->dob)->format('Y-m-d') ?: '-' }}</td>
                                    <td class="px-4 py-2 text-right">
                                        <a href="{{ route('frontdesk.patients.show', $patient) }}" class="text-sky-700 hover:text-sky-800 text-xs font-semibold">View</a>
                                        <a href="{{ route('frontdesk.patients.history', $patient) }}" class="ml-3 text-emerald-700 hover:text-emerald-800 text-xs font-semibold">History</a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="px-4 py-6 text-center text-slate-500">No patients found.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="border-t border-slate-200 px-4 py-3">{{ $patients->links() }}</div>
            </div>
        </div>
    </div>
</x-app-layout>
