<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>Patients Print</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        table { width: 100%; border-collapse: collapse; font-size: 12px; }
        th, td { border: 1px solid #ddd; padding: 6px; text-align: left; }
        th { background: #f4f4f4; }
    </style>
</head>
<body onload="window.print()">
    <h3>Patients List</h3>
    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Name</th>
                <th>Lab</th>
                <th>Email</th>
                <th>Phone</th>
                <th>DOB</th>
                <th>Gender</th>
            </tr>
        </thead>
        <tbody>
            @foreach($patients as $patient)
                <tr>
                    <td>{{ $patient->id }}</td>
                    <td>{{ $patient->full_name }}</td>
                    <td>{{ optional($patient->lab)->name }} {{ optional($patient->lab)->branch_name }}</td>
                    <td>{{ $patient->email }}</td>
                    <td>{{ $patient->phone }}</td>
                    <td>{{ optional($patient->dob)->format('Y-m-d') }}</td>
                    <td>{{ ucfirst($patient->gender ?: '-') }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
