<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-3">
            <h2 class="text-xl font-semibold text-slate-800">{{ $patient->full_name }}</h2>
            <div class="flex items-center gap-2">
                <a href="{{ route('frontdesk.patients.history', $patient) }}" class="rounded-lg border border-slate-300 px-4 py-2 text-sm font-medium text-slate-700">History</a>
                <a href="{{ route('frontdesk.patients.orders.create', $patient) }}" class="rounded-lg bg-emerald-600 px-4 py-2 text-sm font-semibold text-white hover:bg-emerald-700">New order</a>
                <a href="{{ route('frontdesk.patients.edit', $patient) }}" class="rounded-lg border border-slate-300 px-4 py-2 text-sm font-medium text-slate-700">Edit</a>
            </div>
        </div>
    </x-slot>

    <div class="py-6">
        <div class="mx-auto max-w-7xl space-y-4 sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-700">{{ session('success') }}</div>
            @endif

            <div class="rounded-xl border border-slate-200 bg-white p-5 shadow-sm">
                <div class="grid gap-4 md:grid-cols-4 text-sm">
                    <div><p class="text-slate-500">Lab</p><p class="font-medium">{{ optional($patient->lab)->name }} {{ optional($patient->lab)->branch_name }}</p></div>
                    <div><p class="text-slate-500">Email</p><p class="font-medium">{{ $patient->email ?: '-' }}</p></div>
                    <div><p class="text-slate-500">Phone</p><p class="font-medium">{{ $patient->phone ?: '-' }}</p></div>
                    <div><p class="text-slate-500">Gender</p><p class="font-medium">{{ ucfirst($patient->gender ?: '-') }}</p></div>
                    <div><p class="text-slate-500">DOB</p><p class="font-medium">{{ optional($patient->dob)->format('Y-m-d') ?: '-' }}</p></div>
                </div>
            </div>

            <div class="rounded-xl border border-slate-200 bg-white shadow-sm overflow-hidden">
                <div class="border-b border-slate-200 px-4 py-3 flex items-center justify-between">
                    <h3 class="font-semibold text-slate-800">Orders</h3>
                    <form method="POST" action="{{ route('frontdesk.patients.destroy', $patient) }}" onsubmit="return confirm('Delete this patient? This will remove linked orders.');">
                        @csrf
                        @method('DELETE')
                        <button class="rounded-lg border border-red-200 bg-red-50 px-3 py-1 text-xs font-semibold text-red-700">Delete patient</button>
                    </form>
                </div>
                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead class="bg-slate-50 text-slate-600">
                            <tr>
                                <th class="px-4 py-2 text-left">Code</th>
                                <th class="px-4 py-2 text-left">Lab</th>
                                <th class="px-4 py-2 text-left">Status</th>
                                <th class="px-4 py-2 text-left">Total</th>
                                <th class="px-4 py-2 text-right">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($orders as $order)
                                <tr class="border-t border-slate-100">
                                    <td class="px-4 py-2">{{ $order->order_code }}</td>
                                    <td class="px-4 py-2">{{ optional($order->lab)->name }} {{ optional($order->lab)->branch_name }}</td>
                                    <td class="px-4 py-2 uppercase text-xs">{{ $order->status }}</td>
                                    <td class="px-4 py-2">{{ number_format((float) $order->total, 2) }}</td>
                                    <td class="px-4 py-2 text-right"><a class="text-sky-700 hover:text-sky-800 text-xs font-semibold" href="{{ route('frontdesk.orders.show', $order) }}">Open</a></td>
                                </tr>
                            @empty
                                <tr>
                                    <td class="px-4 py-5 text-slate-500" colspan="5">No orders found.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="border-t border-slate-200 px-4 py-3">{{ $orders->links() }}</div>
            </div>
        </div>
    </div>
</x-app-layout>
