@php
    $isEdit = isset($user);
@endphp

<div class="grid grid-cols-1 md:grid-cols-2 gap-4">
    <div>
        <label class="block text-sm font-medium">Name</label>
        <input name="name" class="w-full border rounded p-2" value="{{ old('name', $user->name ?? '') }}" required>
        @error('name') <div class="text-red-600 text-sm">{{ $message }}</div> @enderror
    </div>

    <div>
        <label class="block text-sm font-medium">Email</label>
        <input type="email" name="email" class="w-full border rounded p-2" value="{{ old('email', $user->email ?? '') }}" required>
        @error('email') <div class="text-red-600 text-sm">{{ $message }}</div> @enderror
    </div>

    <div>
        <label class="block text-sm font-medium">Phone</label>
        <input name="phone" class="w-full border rounded p-2" value="{{ old('phone', $user->phone ?? '') }}">
        @error('phone') <div class="text-red-600 text-sm">{{ $message }}</div> @enderror
    </div>

    <div>
        <label class="block text-sm font-medium">Role</label>
        <select name="role" class="w-full border rounded p-2" required>
            @foreach(['lab_manager' => 'Lab Manager', 'lab_staff' => 'Lab Staff'] as $value => $label)
                <option value="{{ $value }}" @selected(old('role', $user->role ?? 'lab_staff') === $value)>{{ $label }}</option>
            @endforeach
        </select>
        @error('role') <div class="text-red-600 text-sm">{{ $message }}</div> @enderror
    </div>

    <div class="md:col-span-2 flex items-center gap-2">
        <input type="checkbox" name="is_active" value="1" {{ old('is_active', $user->is_active ?? true) ? 'checked' : '' }}>
        <label class="text-sm">Active</label>
    </div>

    <div>
        <label class="block text-sm font-medium">{{ $isEdit ? 'Password (leave empty to keep current)' : 'Password' }}</label>
        <x-password-input name="password" class="w-full border rounded p-2" {{ $isEdit ? '' : 'required' }} />
        @error('password') <div class="text-red-600 text-sm">{{ $message }}</div> @enderror
    </div>

    <div>
        <label class="block text-sm font-medium">Confirm Password</label>
        <x-password-input name="password_confirmation" class="w-full border rounded p-2" {{ $isEdit ? '' : 'required' }} />
    </div>
</div>
