<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">Staff Management</h2>
            <a href="{{ route('frontdesk.staff.create') }}" class="px-4 py-2 bg-indigo-600 text-white rounded">Add Staff</a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if(session('success'))
                <div class="mb-4 p-3 bg-green-100 text-green-800 rounded">{{ session('success') }}</div>
            @endif

            <div class="bg-white shadow rounded p-4 mb-4">
                <form method="GET" action="{{ route('frontdesk.staff.index') }}" class="flex gap-2">
                    <input type="text" name="q" value="{{ request('q') }}" class="border rounded p-2 w-full" placeholder="Search name, email, phone, role">
                    <button class="px-4 py-2 border rounded" type="submit">Search</button>
                </form>
            </div>

            <div class="bg-white shadow rounded p-4 overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead>
                        <tr class="text-left border-b">
                            <th class="py-2">Name</th>
                            <th class="py-2">Email</th>
                            <th class="py-2">Phone</th>
                            <th class="py-2">Role</th>
                            <th class="py-2">Status</th>
                            <th class="py-2 text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($staff as $s)
                            <tr class="border-b">
                                <td class="py-2">{{ $s->name }}</td>
                                <td class="py-2">{{ $s->email }}</td>
                                <td class="py-2">{{ $s->phone ?: '-' }}</td>
                                <td class="py-2"><span class="px-2 py-1 rounded bg-slate-100 text-slate-700 text-xs uppercase">{{ str_replace('_', ' ', $s->role) }}</span></td>
                                <td class="py-2">
                                    @if($s->is_active)
                                        <span class="px-2 py-1 rounded bg-green-100 text-green-700 text-xs">Active</span>
                                    @else
                                        <span class="px-2 py-1 rounded bg-gray-100 text-gray-700 text-xs">Inactive</span>
                                    @endif
                                </td>
                                <td class="py-2 text-right">
                                    <a class="text-blue-600" href="{{ route('frontdesk.staff.edit', $s) }}">Edit</a>
                                </td>
                            </tr>
                            <tr class="border-b bg-slate-50">
                                <td colspan="6" class="py-2 text-xs text-slate-600">
                                    <form method="POST" action="{{ route('frontdesk.staff.switch-role', $s) }}" class="flex items-center gap-2">
                                        @csrf
                                        @method('PATCH')
                                        <span class="font-semibold">Switch Role:</span>
                                        <select name="role" class="border rounded p-1 text-xs">
                                            <option value="lab_staff" @selected($s->role === 'lab_staff')>Lab Staff</option>
                                            <option value="lab_manager" @selected($s->role === 'lab_manager')>Lab Manager</option>
                                        </select>
                                        <button type="submit" class="px-2 py-1 rounded bg-indigo-600 text-white text-xs">Apply</button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr><td colspan="6" class="py-6 text-center text-gray-500">No staff found for this lab.</td></tr>
                        @endforelse
                    </tbody>
                </table>

                <div class="mt-4">{{ $staff->links() }}</div>
            </div>
        </div>
    </div>
</x-app-layout>
