<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ $brandName ?? config('app.name', 'Lab Result Portal') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=outfit:500,600,700|manrope:400,500,600,700&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="antialiased text-slate-900 font-['Manrope'] bg-slate-100">
        <div class="min-h-screen relative overflow-hidden">
            <div class="pointer-events-none absolute -top-24 -left-12 h-72 w-72 rounded-full bg-emerald-200/70 blur-3xl"></div>
            <div class="pointer-events-none absolute top-16 -right-16 h-72 w-72 rounded-full bg-sky-200/80 blur-3xl"></div>
            <div class="pointer-events-none absolute -bottom-24 left-1/4 h-72 w-72 rounded-full bg-amber-200/80 blur-3xl"></div>

            <div class="relative min-h-screen grid place-items-center px-4 py-8 sm:px-6 lg:px-8">
                <div class="w-full max-w-5xl rounded-3xl border border-white/70 bg-white/70 shadow-2xl backdrop-blur-sm overflow-hidden">
                    <div class="grid lg:grid-cols-2">
                        <section class="hidden lg:flex flex-col justify-between bg-gradient-to-br from-emerald-600 via-teal-600 to-sky-700 p-10 text-white">
                            <div>
                                <a href="/" class="inline-flex items-center gap-3">
                                    <span class="rounded-xl bg-white/20 p-2">
                                        <x-application-logo class="h-8 w-8 fill-current text-white" />
                                    </span>
                                    <span class="text-lg font-semibold tracking-tight font-['Outfit']">
                                        {{ $brandName ?? config('app.name', 'Lab Result Portal') }}
                                    </span>
                                </a>
                                <h2 class="mt-10 text-4xl leading-tight font-semibold font-['Outfit']">
                                    Secure access to laboratory workflows.
                                </h2>
                                <p class="mt-4 text-white/90 text-sm leading-6 max-w-md">
                                    Sign in to manage patient records, process test orders, and publish reports with controlled access.
                                </p>
                            </div>
                            <div class="grid gap-3 text-sm">
                                <div class="rounded-xl border border-white/30 bg-white/10 px-4 py-3">Real-time order status and report tracking</div>
                                <div class="rounded-xl border border-white/30 bg-white/10 px-4 py-3">Role-based access for staff and management</div>
                                <div class="rounded-xl border border-white/30 bg-white/10 px-4 py-3">Centralized patient and billing records</div>
                            </div>
                        </section>

                        <section class="bg-white/90 p-6 sm:p-10">
                            <div class="mb-8 flex items-center justify-between lg:hidden">
                                <a href="/" class="inline-flex items-center gap-2">
                                    <x-application-logo class="h-8 w-8 fill-current text-emerald-600" />
                                    <span class="text-base font-semibold tracking-tight font-['Outfit']">
                                        {{ $brandName ?? config('app.name', 'Lab Result Portal') }}
                                    </span>
                                </a>
                            </div>
                            <x-validation-errors class="mb-4" />
                            {{ $slot }}
                        </section>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>
