@php
    $user = auth()->user();
    $role = $user->role ?? null;
@endphp

<nav x-data="{ open: false }" class="bg-white border-b border-slate-200">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between h-16">
            <div class="flex">
                <div class="shrink-0 flex items-center">
                    <a href="{{ route('dashboard') }}" class="inline-flex items-center gap-2">
                        <x-application-logo class="block h-8 w-auto fill-current text-slate-800" />
                        <span class="text-sm font-semibold text-slate-800">{{ $brandName ?? config('app.name', 'Lab Result Portal') }}</span>
                    </a>
                </div>

                <div class="hidden space-x-6 sm:-my-px sm:ml-8 sm:flex">
                    <x-nav-link :href="route('dashboard')" :active="request()->routeIs('dashboard')">
                        Dashboard
                    </x-nav-link>

                    @if(in_array($role, ['super_admin', 'lab_manager', 'lab_staff'], true))
                        <x-nav-link :href="route('frontdesk.patients.index')" :active="request()->routeIs('frontdesk.patients.*')">
                            Patients
                        </x-nav-link>
                        <x-nav-link :href="route('frontdesk.orders.index')" :active="request()->routeIs('frontdesk.orders.*')">
                            Orders
                        </x-nav-link>
                        <x-nav-link :href="route('frontdesk.otps.index')" :active="request()->routeIs('frontdesk.otps.*')">
                            OTP Log
                        </x-nav-link>
                    @endif

                    @if($role === 'lab_manager')
                        <x-nav-link :href="route('frontdesk.staff.index')" :active="request()->routeIs('frontdesk.staff.*')">
                            Staff
                        </x-nav-link>
                    @endif

                    @if($role === 'super_admin')
                        <x-nav-link :href="route('admin.users.index')" :active="request()->routeIs('admin.users.*')">
                            Users
                        </x-nav-link>
                        <x-nav-link :href="route('admin.labs.index')" :active="request()->routeIs('admin.labs.*')">
                            Labs
                        </x-nav-link>
                        <x-nav-link :href="route('admin.branding.edit')" :active="request()->routeIs('admin.branding.*')">
                            Branding
                        </x-nav-link>
                        <x-nav-link :href="route('admin.categories.index')" :active="request()->routeIs('admin.categories.*')">
                            Categories
                        </x-nav-link>
                        <x-nav-link :href="route('admin.tests.index')" :active="request()->routeIs('admin.tests.*')">
                            Tests
                        </x-nav-link>
                    @endif
                </div>
            </div>

            <div class="hidden sm:flex sm:items-center sm:ml-6">
                <x-dropdown align="right" width="56">
                    <x-slot name="trigger">
                        <button class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-slate-600 bg-white hover:text-slate-900 focus:outline-none transition">
                            <div>{{ $user->name ?? 'User' }}</div>

                            <div class="ml-1">
                                <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                </svg>
                            </div>
                        </button>
                    </x-slot>

                    <x-slot name="content">
                        <div class="px-4 py-2 text-xs text-slate-500 border-b border-slate-100 uppercase">
                            {{ str_replace('_', ' ', $role ?? 'user') }}
                        </div>
                        <x-dropdown-link :href="route('profile.edit')">
                            Profile
                        </x-dropdown-link>

                        <form method="POST" action="{{ route('logout') }}">
                            @csrf
                            <x-dropdown-link :href="route('logout')" onclick="event.preventDefault(); this.closest('form').submit();">
                                Log Out
                            </x-dropdown-link>
                        </form>
                    </x-slot>
                </x-dropdown>
            </div>

            <div class="-mr-2 flex items-center sm:hidden">
                <button @click="open = ! open" class="inline-flex items-center justify-center p-2 rounded-md text-slate-500 hover:text-slate-700 hover:bg-slate-100 focus:outline-none transition">
                    <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                        <path :class="{'hidden': open, 'inline-flex': ! open }" class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        <path :class="{'hidden': ! open, 'inline-flex': open }" class="hidden" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <div :class="{'block': open, 'hidden': ! open}" class="hidden sm:hidden">
        <div class="pt-2 pb-3 space-y-1">
            <x-responsive-nav-link :href="route('dashboard')" :active="request()->routeIs('dashboard')">Dashboard</x-responsive-nav-link>

            @if(in_array($role, ['super_admin', 'lab_manager', 'lab_staff'], true))
                <x-responsive-nav-link :href="route('frontdesk.patients.index')" :active="request()->routeIs('frontdesk.patients.*')">Patients</x-responsive-nav-link>
                <x-responsive-nav-link :href="route('frontdesk.orders.index')" :active="request()->routeIs('frontdesk.orders.*')">Orders</x-responsive-nav-link>
                <x-responsive-nav-link :href="route('frontdesk.otps.index')" :active="request()->routeIs('frontdesk.otps.*')">OTP Log</x-responsive-nav-link>
            @endif

            @if($role === 'lab_manager')
                <x-responsive-nav-link :href="route('frontdesk.staff.index')" :active="request()->routeIs('frontdesk.staff.*')">Staff</x-responsive-nav-link>
            @endif

            @if($role === 'super_admin')
                <x-responsive-nav-link :href="route('admin.users.index')" :active="request()->routeIs('admin.users.*')">Users</x-responsive-nav-link>
                <x-responsive-nav-link :href="route('admin.labs.index')" :active="request()->routeIs('admin.labs.*')">Labs</x-responsive-nav-link>
                <x-responsive-nav-link :href="route('admin.branding.edit')" :active="request()->routeIs('admin.branding.*')">Branding</x-responsive-nav-link>
                <x-responsive-nav-link :href="route('admin.categories.index')" :active="request()->routeIs('admin.categories.*')">Categories</x-responsive-nav-link>
                <x-responsive-nav-link :href="route('admin.tests.index')" :active="request()->routeIs('admin.tests.*')">Tests</x-responsive-nav-link>
            @endif
        </div>

        <div class="pt-4 pb-1 border-t border-slate-200">
            <div class="px-4">
                <div class="font-medium text-base text-slate-800">{{ $user->name ?? 'User' }}</div>
                <div class="font-medium text-sm text-slate-500">{{ $user->email ?? '' }}</div>
            </div>

            <div class="mt-3 space-y-1">
                <x-responsive-nav-link :href="route('profile.edit')">Profile</x-responsive-nav-link>
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <x-responsive-nav-link :href="route('logout')" onclick="event.preventDefault(); this.closest('form').submit();">Log Out</x-responsive-nav-link>
                </form>
            </div>
        </div>
    </div>
</nav>
