<x-guest-layout>
    <div class="mb-6 overflow-hidden rounded-2xl border border-slate-200 bg-gradient-to-br from-sky-50 via-indigo-50 to-white">
        <div class="grid gap-3 p-4 sm:grid-cols-[1.1fr_.9fr] sm:p-5">
            <div class="flex flex-col justify-center">
                <p class="text-xs font-semibold uppercase tracking-[0.12em] text-sky-700">Patient Access</p>
                <h2 class="mt-1 text-lg font-semibold text-slate-900 sm:text-xl">OTP Login Portal</h2>
                <p class="mt-1 text-sm text-slate-600">Use your registered email or phone number to get a secure one-time code.</p>
            </div>
            <div class="rounded-xl border border-slate-100 bg-white p-2 shadow-sm">
                <img
                    src="{{ asset('images/landing-lab-hero.svg') }}"
                    alt="Laboratory illustration"
                    class="h-32 w-full rounded-lg object-cover object-center sm:h-36"
                >
            </div>
        </div>
    </div>

    <div class="mb-6">
        <h1 class="auth-page-title">Patient OTP login</h1>
        <p class="auth-page-text">Enter your registered email or phone. We will send a one-time code to email, SMS, and WhatsApp (where available).</p>
    </div>

    <x-auth-session-status class="mb-4" :status="session('status')" />

    <form method="POST" action="{{ route('patient.otp.request') }}" class="auth-form-stack">
        @csrf

        <div>
            <x-input-label for="identifier" value="Email or Phone" />
            <x-text-input id="identifier" name="identifier" type="text" class="block mt-1 w-full" :value="old('identifier')" required autofocus placeholder="name@example.com or +234..." />
            <x-input-error :messages="$errors->get('identifier')" class="mt-2" />
        </div>

        <div class="flex items-center justify-end pt-2">
            <x-primary-button>
                Send OTP
            </x-primary-button>
        </div>
    </form>
</x-guest-layout>
