<x-guest-layout>
    <div class="mb-6 overflow-hidden rounded-2xl border border-slate-200 bg-gradient-to-br from-sky-50 via-indigo-50 to-white">
        <div class="grid gap-3 p-4 sm:grid-cols-[1.1fr_.9fr] sm:p-5">
            <div class="flex flex-col justify-center">
                <p class="text-xs font-semibold uppercase tracking-[0.12em] text-sky-700">Patient Access</p>
                <h2 class="mt-1 text-lg font-semibold text-slate-900 sm:text-xl">Verify One-Time Password</h2>
                <p class="mt-1 text-sm text-slate-600">Enter the OTP sent to your channels to continue to your patient portal.</p>
            </div>
            <div class="rounded-xl border border-slate-100 bg-white p-2 shadow-sm">
                <img
                    src="{{ asset('images/landing-lab-hero.svg') }}"
                    alt="Laboratory illustration"
                    class="h-32 w-full rounded-lg object-cover object-center sm:h-36"
                >
            </div>
        </div>
    </div>

    <div class="mb-6">
        <h1 class="auth-page-title">Verify OTP</h1>
        <p class="auth-page-text">Enter the 6-digit code sent to your registered channels.</p>
    </div>

    <x-auth-session-status class="mb-4" :status="session('status')" />

    <form method="POST" action="{{ route('patient.otp.verify.store') }}" class="auth-form-stack">
        @csrf

        <div>
            <x-input-label for="otp" value="One-time code" />
            <x-text-input id="otp" name="otp" type="text" inputmode="numeric" pattern="[0-9]{6}" maxlength="6" class="block mt-1 w-full" required autofocus placeholder="123456" />
            <x-input-error :messages="$errors->get('otp')" class="mt-2" />
        </div>

        <div class="flex items-center justify-between pt-2">
            <a href="{{ route('patient.login') }}" class="auth-link">Use another email/phone</a>
            <x-primary-button>
                Verify and login
            </x-primary-button>
        </div>
    </form>
</x-guest-layout>
