<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Patient Portal - {{ $brandName ?? config('app.name', 'Lab Result Portal') }}</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="bg-slate-100 text-slate-900 antialiased">
    <main class="mx-auto max-w-5xl px-4 py-8 sm:px-6 lg:px-8">
        <div class="mb-6 flex flex-wrap items-center justify-between gap-3 rounded-2xl border border-slate-200 bg-white p-5 shadow-sm">
            <div>
                <p class="text-sm text-slate-600">Signed in as</p>
                <h1 class="text-2xl font-semibold">{{ $patient->full_name }}</h1>
                <p class="text-sm text-slate-600">{{ $patient->email ?: 'No email' }} | {{ $patient->phone ?: 'No phone' }}</p>
            </div>
            <div class="flex items-center gap-2">
                <a href="{{ route('patient.transactions.receipt') }}" class="inline-flex items-center justify-center rounded-lg border border-slate-300 px-4 py-2 text-sm font-semibold text-slate-700 hover:bg-slate-50">
                    Download Receipt
                </a>
                <form method="POST" action="{{ route('patient.logout') }}">
                    @csrf
                    <x-primary-button>Logout</x-primary-button>
                </form>
            </div>
        </div>

        <section class="rounded-2xl border border-slate-200 bg-white p-5 shadow-sm">
            <h2 class="mb-4 text-lg font-semibold">My Lab Orders</h2>

            @if ($orders->isEmpty())
                <p class="text-sm text-slate-600">No lab orders found yet.</p>
            @else
                <div class="space-y-3">
                    @foreach ($orders as $order)
                        <article class="rounded-xl border border-slate-200 p-4">
                            <div class="flex flex-wrap items-start justify-between gap-2">
                                <div>
                                    <p class="text-sm text-slate-600">Order</p>
                                    <p class="font-semibold">{{ $order->order_code }}</p>
                                    <p class="text-xs text-slate-500">
                                        {{ optional($order->lab)->name }}{{ optional($order->lab)->branch_name ? ' - '.optional($order->lab)->branch_name : '' }}
                                    </p>
                                </div>
                                <span class="rounded-full bg-sky-100 px-3 py-1 text-xs font-semibold uppercase text-sky-700">{{ $order->status }}</span>
                            </div>

                            <div class="mt-3 text-sm text-slate-700">
                                <p>Total: {{ number_format((float) $order->total, 2) }}</p>
                                <p>Paid: {{ number_format((float) $order->paid, 2) }} | Balance: {{ number_format((float) $order->balance, 2) }}</p>
                            </div>

                            <div class="mt-3 border-t border-slate-200 pt-3">
                                <p class="text-xs font-semibold uppercase text-slate-500">Results</p>
                                @forelse($order->results as $result)
                                    <div class="mt-1 text-sm">
                                        <a href="{{ route('patient.results.download', [$order, $result]) }}" class="text-sky-700 hover:text-sky-800">
                                            Download version {{ $result->version }}
                                        </a>
                                        <span class="text-slate-500">({{ optional($result->created_at)->format('Y-m-d H:i') }})</span>
                                    </div>
                                @empty
                                    <p class="text-sm text-slate-500 mt-1">No result uploaded yet.</p>
                                @endforelse
                            </div>
                        </article>
                    @endforeach
                </div>
            @endif
        </section>
    </main>
</body>
</html>
