<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; color: #111827; }
        h2, h3 { margin: 0 0 8px; }
        .meta { margin-bottom: 16px; }
        .meta p { margin: 2px 0; }
        table { width: 100%; border-collapse: collapse; margin-top: 8px; }
        th, td { border: 1px solid #e5e7eb; padding: 6px; text-align: left; }
        th { background: #f9fafb; }
        .totals { margin-top: 12px; width: 45%; margin-left: auto; }
        .totals td { border: 1px solid #e5e7eb; padding: 6px; }
        .right { text-align: right; }
    </style>
</head>
<body>
    <h2>Patient Transaction Receipt</h2>
    <div class="meta">
        <p><strong>Patient:</strong> {{ $patient->full_name }}</p>
        <p><strong>Email:</strong> {{ $patient->email ?: '-' }}</p>
        <p><strong>Phone:</strong> {{ $patient->phone ?: '-' }}</p>
        <p><strong>Generated:</strong> {{ now()->format('Y-m-d H:i:s') }}</p>
    </div>

    <h3>Transactions</h3>
    <table>
        <thead>
            <tr>
                <th>Order</th>
                <th>Lab</th>
                <th>Method</th>
                <th>Reference</th>
                <th>Date</th>
                <th class="right">Amount (&#8358;)</th>
            </tr>
        </thead>
        <tbody>
            @forelse($payments as $row)
                <tr>
                    <td>{{ $row['order_code'] }}</td>
                    <td>{{ $row['lab'] ?: '-' }}</td>
                    <td>{{ strtoupper($row['method']) }}</td>
                    <td>{{ $row['reference'] ?: '-' }}</td>
                    <td>{{ optional($row['paid_at'])->format('Y-m-d H:i') ?: '-' }}</td>
                    <td class="right">{{ number_format((float) $row['amount'], 2) }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="6">No transactions found.</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <table class="totals">
        <tbody>
            <tr>
                <td>Total Billed</td>
                <td class="right">&#8358;{{ number_format((float) $totalBilled, 2) }}</td>
            </tr>
            <tr>
                <td>Total Paid</td>
                <td class="right">&#8358;{{ number_format((float) $totalPaid, 2) }}</td>
            </tr>
            <tr>
                <td><strong>Balance</strong></td>
                <td class="right"><strong>&#8358;{{ number_format((float) $totalBalance, 2) }}</strong></td>
            </tr>
        </tbody>
    </table>
</body>
</html>
