<?php

use Illuminate\Support\Facades\Route;

// --- Admin ---
use App\Http\Controllers\Admin\LabController;
use App\Http\Controllers\Admin\TestCatalogController;
use App\Http\Controllers\Admin\LabPricingController;
use App\Http\Controllers\Admin\UserController as AdminUserController;
use App\Http\Controllers\Admin\TestCategoryController;
use App\Http\Controllers\Admin\BrandingController;
use App\Http\Controllers\Auth\PatientOtpLoginController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ProfileController;

// --- Frontdesk ---
use App\Http\Controllers\Frontdesk\PatientController;
use App\Http\Controllers\Frontdesk\OrderController;
use App\Http\Controllers\Frontdesk\OrderItemController;
use App\Http\Controllers\Frontdesk\PaymentController;
use App\Http\Controllers\Frontdesk\ResultController;
use App\Http\Controllers\Frontdesk\OtpController;
use App\Http\Controllers\Frontdesk\StaffController;

Route::get('/', function () {
    return view('welcome');
});

Route::view('/documentation', 'documentation')->name('documentation');

Route::middleware('guest:patient')->group(function () {
    Route::get('/patient/login', [PatientOtpLoginController::class, 'showRequestForm'])->name('patient.login');
    Route::post('/patient/login/request-otp', [PatientOtpLoginController::class, 'requestOtp'])->name('patient.otp.request');
    Route::get('/patient/login/verify-otp', [PatientOtpLoginController::class, 'showVerifyForm'])->name('patient.otp.verify');
    Route::post('/patient/login/verify-otp', [PatientOtpLoginController::class, 'verifyOtp'])->name('patient.otp.verify.store');
});

Route::middleware('patient.auth')->group(function () {
    Route::get('/patient/portal', [PatientOtpLoginController::class, 'portal'])->name('patient.portal');
    Route::get('/patient/transactions/receipt', [PatientOtpLoginController::class, 'downloadTransactionsReceipt'])->name('patient.transactions.receipt');
    Route::get('/patient/orders/{order}/results/{result}/download', [PatientOtpLoginController::class, 'downloadResult'])->name('patient.results.download');
    Route::post('/patient/logout', [PatientOtpLoginController::class, 'logout'])->name('patient.logout');
});

Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('/dashboard', DashboardController::class)->name('dashboard');

    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    Route::prefix('admin')->name('admin.')->middleware('role:super_admin')->group(function () {
        Route::resource('labs', LabController::class);
        Route::resource('users', AdminUserController::class)->except(['show']);
        Route::patch('users/{user}/switch-role', [AdminUserController::class, 'switchRole'])->name('users.switch-role');
        Route::resource('categories', TestCategoryController::class)->except(['show']);
        Route::get('branding', [BrandingController::class, 'edit'])->name('branding.edit');
        Route::put('branding', [BrandingController::class, 'update'])->name('branding.update');

        Route::resource('tests', TestCatalogController::class)->except(['show']);

        Route::get('labs/{lab}/pricing', [LabPricingController::class, 'edit'])->name('labs.pricing.edit');
        Route::put('labs/{lab}/pricing', [LabPricingController::class, 'update'])->name('labs.pricing.update');
    });

    Route::prefix('frontdesk')->name('frontdesk.')
        ->middleware('role:super_admin,lab_manager,lab_staff')
        ->group(function () {

        Route::get('patients-export.csv', [PatientController::class, 'exportCsv'])->name('patients.export.csv');
        Route::get('patients-export.pdf', [PatientController::class, 'exportPdf'])->name('patients.export.pdf');
        Route::get('patients-print', [PatientController::class, 'print'])->name('patients.print');
        Route::resource('patients', PatientController::class);
        Route::get('patients/{patient}/history', [PatientController::class, 'history'])->name('patients.history');

        Route::get('orders', [OrderController::class, 'index'])->name('orders.index');
        Route::get('otps', [OtpController::class, 'index'])->name('otps.index');
        Route::get('orders-export.csv', [OrderController::class, 'exportCsv'])->name('orders.export.csv');
        Route::get('orders-export.pdf', [OrderController::class, 'exportPdf'])->name('orders.export.pdf');
        Route::get('orders-print', [OrderController::class, 'print'])->name('orders.print');

        Route::get('patients/{patient}/orders/create', [OrderController::class, 'create'])->name('patients.orders.create');
        Route::post('patients/{patient}/orders', [OrderController::class, 'store'])->name('patients.orders.store');

        Route::get('orders/{order}', [OrderController::class, 'show'])->name('orders.show');
        Route::put('orders/{order}', [OrderController::class, 'update'])->name('orders.update');
        Route::delete('orders/{order}', [OrderController::class, 'destroy'])->name('orders.destroy');

        Route::post('orders/{order}/items', [OrderItemController::class, 'store'])->name('orders.items.store');
        Route::delete('orders/{order}/items/{item}', [OrderItemController::class, 'destroy'])->name('orders.items.destroy');

        Route::post('orders/{order}/payments', [PaymentController::class, 'store'])->name('orders.payments.store');
        Route::delete('orders/{order}/payments/{payment}', [PaymentController::class, 'destroy'])->name('orders.payments.destroy');

        Route::post('orders/{order}/results', [ResultController::class, 'store'])->name('orders.results.store');
        Route::delete('orders/{order}/results/{result}', [ResultController::class, 'destroy'])->name('orders.results.destroy');
        Route::get('orders/{order}/results/{result}/download', [ResultController::class, 'download'])->name('orders.results.download');
    });

    Route::prefix('frontdesk')->name('frontdesk.')
        ->middleware('role:lab_manager')
        ->group(function () {
            Route::get('staff', [StaffController::class, 'index'])->name('staff.index');
            Route::get('staff/create', [StaffController::class, 'create'])->name('staff.create');
            Route::post('staff', [StaffController::class, 'store'])->name('staff.store');
            Route::get('staff/{user}/edit', [StaffController::class, 'edit'])->name('staff.edit');
            Route::put('staff/{user}', [StaffController::class, 'update'])->name('staff.update');
            Route::patch('staff/{user}/switch-role', [StaffController::class, 'switchRole'])->name('staff.switch-role');
        });
});

require __DIR__.'/auth.php';
