<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">Users</h2>
            <a href="<?php echo e(route('admin.users.create')); ?>" class="px-4 py-2 bg-indigo-600 text-white rounded">Add User</a>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-8">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <?php if(session('success')): ?>
                <div class="mb-4 p-3 bg-green-100 text-green-800 rounded"><?php echo e(session('success')); ?></div>
            <?php endif; ?>

            <div class="bg-white shadow rounded p-4 mb-4">
                <form method="GET" action="<?php echo e(route('admin.users.index')); ?>" class="flex gap-2">
                    <input type="text" name="q" value="<?php echo e(request('q')); ?>" class="border rounded p-2 w-full" placeholder="Search name, email, phone, role">
                    <button class="px-4 py-2 border rounded" type="submit">Search</button>
                </form>
            </div>

            <div class="bg-white shadow rounded p-4 overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead>
                        <tr class="text-left border-b">
                            <th class="py-2">Name</th>
                            <th class="py-2">Email</th>
                            <th class="py-2">Role</th>
                            <th class="py-2">Lab</th>
                            <th class="py-2">Status</th>
                            <th class="py-2 text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="border-b">
                                <td class="py-2"><?php echo e($u->name); ?></td>
                                <td class="py-2"><?php echo e($u->email); ?></td>
                                <td class="py-2">
                                    <span class="px-2 py-1 rounded bg-slate-100 text-slate-700 text-xs uppercase"><?php echo e(str_replace('_', ' ', $u->role)); ?></span>
                                </td>
                                <td class="py-2"><?php echo e($u->lab ? ('#'.$u->lab->id.' '.$u->lab->name) : '-'); ?></td>
                                <td class="py-2">
                                    <?php if($u->is_active): ?>
                                        <span class="px-2 py-1 rounded bg-green-100 text-green-700 text-xs">Active</span>
                                    <?php else: ?>
                                        <span class="px-2 py-1 rounded bg-gray-100 text-gray-700 text-xs">Inactive</span>
                                    <?php endif; ?>
                                </td>
                                <td class="py-2 text-right space-x-2">
                                    <a class="text-blue-600" href="<?php echo e(route('admin.users.edit', $u)); ?>">Edit</a>
                                    <form class="inline" method="POST" action="<?php echo e(route('admin.users.destroy', $u)); ?>" onsubmit="return confirm('Delete this user?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button class="text-red-600" type="submit">Delete</button>
                                    </form>
                                </td>
                            </tr>
                            <tr class="border-b bg-slate-50">
                                <td class="py-2 text-xs text-slate-600" colspan="6">
                                    <form method="POST" action="<?php echo e(route('admin.users.switch-role', $u)); ?>" class="flex flex-wrap items-center gap-2">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PATCH'); ?>
                                        <span class="font-semibold">Switch Role:</span>
                                        <select name="role" class="border rounded p-1 text-xs">
                                            <?php $__currentLoopData = ['super_admin' => 'Super Admin', 'lab_manager' => 'Lab Manager', 'lab_staff' => 'Lab Staff']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($value); ?>" <?php if($u->role === $value): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <select name="lab_id" class="border rounded p-1 text-xs">
                                            <option value="">No Lab</option>
                                            <?php $__currentLoopData = $labs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($lab->id); ?>" <?php if((int) $u->lab_id === (int) $lab->id): echo 'selected'; endif; ?>>
                                                    #<?php echo e($lab->id); ?> - <?php echo e($lab->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <button type="submit" class="px-2 py-1 rounded bg-indigo-600 text-white text-xs">Apply</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr><td colspan="6" class="py-6 text-center text-gray-500">No users found.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>

                <div class="mt-4"><?php echo e($users->links()); ?></div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\wamp64\www\lab-result-portal\resources\views/admin/users/index.blade.php ENDPATH**/ ?>