<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>Orders Print</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        table { width: 100%; border-collapse: collapse; font-size: 12px; }
        th, td { border: 1px solid #ddd; padding: 6px; text-align: left; }
        th { background: #f4f4f4; }
    </style>
</head>
<body onload="window.print()">
    <h3>Orders List</h3>
    <table>
        <thead>
            <tr>
                <th>Code</th>
                <th>Lab</th>
                <th>Patient</th>
                <th>Status</th>
                <th>Total</th>
                <th>Paid</th>
                <th>Balance</th>
                <th>Date</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($order->order_code); ?></td>
                    <td><?php echo e(optional($order->lab)->name); ?> <?php echo e(optional($order->lab)->branch_name); ?></td>
                    <td><?php echo e(optional($order->patient)->full_name); ?></td>
                    <td><?php echo e(strtoupper($order->status)); ?></td>
                    <td><?php echo e(number_format((float) $order->total, 2)); ?></td>
                    <td><?php echo e(number_format((float) $order->paid, 2)); ?></td>
                    <td><?php echo e(number_format((float) $order->balance, 2)); ?></td>
                    <td><?php echo e(optional($order->created_at)->format('Y-m-d H:i')); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html>
<?php /**PATH C:\wamp64\www\lab-result-portal\resources\views\frontdesk\orders\print.blade.php ENDPATH**/ ?>