<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex flex-wrap items-center justify-between gap-3">
            <h2 class="text-xl font-semibold text-slate-800">Order <?php echo e($order->order_code); ?></h2>
            <a href="<?php echo e(route('frontdesk.orders.index')); ?>" class="rounded-lg border border-slate-300 px-3 py-2 text-sm font-medium text-slate-700">Back to orders</a>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-6">
        <div class="mx-auto max-w-7xl space-y-4 sm:px-6 lg:px-8">
            <?php if(session('success')): ?>
                <div class="rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-700"><?php echo e(session('success')); ?></div>
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <div class="rounded-lg border border-red-200 bg-red-50 px-4 py-3 text-sm text-red-700">
                    <ul class="list-disc pl-5">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <div class="rounded-xl border border-slate-200 bg-white p-5 shadow-sm">
                <div class="grid gap-4 md:grid-cols-5 text-sm">
                    <div><p class="text-slate-500">Patient</p><p class="font-medium"><?php echo e($order->patient->full_name); ?></p></div>
                    <div><p class="text-slate-500">Lab</p><p class="font-medium"><?php echo e(optional($order->lab)->name); ?> <?php echo e(optional($order->lab)->branch_name); ?></p></div>
                    <div><p class="text-slate-500">Status</p><p class="font-medium uppercase"><?php echo e($order->status); ?></p></div>
                    <div><p class="text-slate-500">Total</p><p class="font-medium"><?php echo e(number_format((float) $order->total, 2)); ?></p></div>
                    <div><p class="text-slate-500">Balance</p><p class="font-medium"><?php echo e(number_format((float) $order->balance, 2)); ?></p></div>
                </div>

                <div class="mt-4 grid gap-3 md:grid-cols-4">
                    <form method="POST" action="<?php echo e(route('frontdesk.orders.update', $order)); ?>" class="md:col-span-3 grid gap-3 md:grid-cols-3">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div>
                            <label class="block text-xs font-medium text-slate-600">Status</label>
                            <select name="status" class="mt-1 w-full rounded-lg border-slate-300">
                                <?php $__currentLoopData = ['draft','pending','paid','ready','delivered','cancelled']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($status); ?>" <?php if($order->status === $status): echo 'selected'; endif; ?>><?php echo e(ucfirst($status)); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div>
                            <label class="block text-xs font-medium text-slate-600">Discount</label>
                            <input type="number" step="0.01" min="0" name="discount" value="<?php echo e($order->discount); ?>" class="mt-1 w-full rounded-lg border-slate-300">
                            <?php $__errorArgs = ['discount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="flex items-end">
                            <button type="submit" class="w-full rounded-lg bg-sky-600 px-4 py-2 text-sm font-semibold text-white hover:bg-sky-700">Update order</button>
                        </div>
                    </form>
                    <form method="POST" action="<?php echo e(route('frontdesk.orders.destroy', $order)); ?>" onsubmit="return confirm('Delete this order?')" class="flex items-end">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button class="w-full rounded-lg border border-red-200 bg-red-50 px-4 py-2 text-sm font-semibold text-red-700">Delete</button>
                    </form>
                </div>
            </div>

            <div class="grid gap-4 lg:grid-cols-3">
                <section class="rounded-xl border border-slate-200 bg-white shadow-sm overflow-hidden lg:col-span-2">
                    <div class="border-b border-slate-200 px-4 py-3 flex items-center justify-between">
                        <h3 class="font-semibold text-slate-800">Test Items</h3>
                    </div>
                    <div class="overflow-x-auto">
                        <table class="min-w-full text-sm">
                            <thead class="bg-slate-50 text-slate-600">
                                <tr>
                                    <th class="px-4 py-2 text-left">Test</th>
                                    <th class="px-4 py-2 text-left">Qty</th>
                                    <th class="px-4 py-2 text-left">Price</th>
                                    <th class="px-4 py-2 text-left">Total</th>
                                    <th class="px-4 py-2 text-right">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr class="border-t border-slate-100">
                                        <td class="px-4 py-2"><?php echo e($item->test->name ?? '-'); ?></td>
                                        <td class="px-4 py-2"><?php echo e($item->qty); ?></td>
                                        <td class="px-4 py-2"><?php echo e(number_format((float) $item->price, 2)); ?></td>
                                        <td class="px-4 py-2"><?php echo e(number_format((float) $item->line_total, 2)); ?></td>
                                        <td class="px-4 py-2 text-right">
                                            <form method="POST" action="<?php echo e(route('frontdesk.orders.items.destroy', [$order, $item])); ?>" onsubmit="return confirm('Remove item?')">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button class="text-xs font-semibold text-red-700">Remove</button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="5" class="px-4 py-4 text-slate-500">No tests added yet.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="border-t border-slate-200 p-4">
                        <form method="POST" action="<?php echo e(route('frontdesk.orders.items.store', $order)); ?>" class="grid gap-2 md:grid-cols-12">
                            <?php echo csrf_field(); ?>
                            <select name="test_id" class="md:col-span-8 rounded-lg border-slate-300" required>
                                <option value="">Select test</option>
                                <?php $__currentLoopData = $tests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $test): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($test->id); ?>"><?php echo e($test->code); ?> - <?php echo e($test->name); ?> (<?php echo e(number_format((float) ($overrides[$test->id]->price ?? $test->default_price), 2)); ?>)</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="number" name="qty" min="1" value="1" class="md:col-span-2 rounded-lg border-slate-300" required>
                            <button class="md:col-span-2 rounded-lg bg-slate-800 px-3 py-2 text-sm font-semibold text-white hover:bg-slate-900">Add item</button>
                        </form>
                        <?php $__errorArgs = ['test_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-2 text-xs text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <?php $__errorArgs = ['qty'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-xs text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </section>

                <section class="space-y-4">
                    <div class="rounded-xl border border-slate-200 bg-white p-4 shadow-sm">
                        <h3 class="font-semibold text-slate-800">Record Payment</h3>
                        <form method="POST" action="<?php echo e(route('frontdesk.orders.payments.store', $order)); ?>" class="mt-3 space-y-2">
                            <?php echo csrf_field(); ?>
                            <input type="number" step="0.01" min="0.01" name="amount" value="<?php echo e(old('amount')); ?>" placeholder="Amount" class="w-full rounded-lg border-slate-300" required>
                            <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-xs text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <select name="method" class="w-full rounded-lg border-slate-300" required>
                                <?php $__currentLoopData = ['cash','transfer','pos','card','online','other']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($method); ?>" <?php if(old('method') === $method): echo 'selected'; endif; ?>><?php echo e(strtoupper($method)); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['method'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-xs text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <input type="text" name="reference" value="<?php echo e(old('reference')); ?>" placeholder="Reference (optional)" class="w-full rounded-lg border-slate-300">
                            <?php $__errorArgs = ['reference'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-xs text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <button class="w-full rounded-lg bg-emerald-600 px-3 py-2 text-sm font-semibold text-white hover:bg-emerald-700">Save payment</button>
                        </form>

                        <div class="mt-3 border-t border-slate-200 pt-3 space-y-2">
                            <?php $__empty_1 = true; $__currentLoopData = $order->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="flex items-center justify-between text-xs">
                                    <span><?php echo e(strtoupper($payment->method)); ?> <?php echo e(number_format((float) $payment->amount, 2)); ?></span>
                                    <form method="POST" action="<?php echo e(route('frontdesk.orders.payments.destroy', [$order, $payment])); ?>" onsubmit="return confirm('Delete payment?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button class="text-red-700">Delete</button>
                                    </form>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <p class="text-xs text-slate-500">No payments yet.</p>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="rounded-xl border border-slate-200 bg-white p-4 shadow-sm">
                        <h3 class="font-semibold text-slate-800">Upload Result</h3>
                        <p class="mt-1 text-xs text-slate-500">Uploaded file will be watermarked automatically.</p>
                        <form method="POST" action="<?php echo e(route('frontdesk.orders.results.store', $order)); ?>" enctype="multipart/form-data" class="mt-3 space-y-2">
                            <?php echo csrf_field(); ?>
                            <input type="file" name="result_file" class="w-full rounded-lg border-slate-300" required>
                            <?php $__errorArgs = ['result_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-xs text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <button class="w-full rounded-lg bg-sky-600 px-3 py-2 text-sm font-semibold text-white hover:bg-sky-700">Upload result</button>
                        </form>

                        <div class="mt-3 border-t border-slate-200 pt-3 space-y-2">
                            <?php $__empty_1 = true; $__currentLoopData = $order->results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="text-xs">
                                    <div class="flex items-center justify-between">
                                        <a href="<?php echo e(route('frontdesk.orders.results.download', [$order, $result])); ?>" class="text-sky-700 hover:text-sky-800">Version <?php echo e($result->version); ?> download</a>
                                        <form method="POST" action="<?php echo e(route('frontdesk.orders.results.destroy', [$order, $result])); ?>" onsubmit="return confirm('Delete result?')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button class="text-red-700">Delete</button>
                                        </form>
                                    </div>
                                    <p class="text-slate-500"><?php echo e(optional($result->created_at)->format('Y-m-d H:i')); ?></p>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <p class="text-xs text-slate-500">No result uploaded yet.</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\wamp64\www\lab-result-portal\resources\views\frontdesk\orders\show.blade.php ENDPATH**/ ?>