<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex flex-wrap items-center justify-between gap-3">
            <h2 class="text-xl font-semibold text-slate-800">Patient History: <?php echo e($patient->full_name); ?></h2>
            <a href="<?php echo e(route('frontdesk.patients.show', $patient)); ?>" class="rounded-lg border border-slate-300 px-4 py-2 text-sm font-medium text-slate-700">Back to profile</a>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-6">
        <div class="mx-auto max-w-7xl space-y-4 sm:px-6 lg:px-8">
            <div class="rounded-xl border border-slate-200 bg-white p-5 shadow-sm">
                <h3 class="font-semibold text-slate-800">Patient Details</h3>
                <div class="mt-3 grid gap-4 md:grid-cols-5 text-sm">
                    <div><p class="text-slate-500">Full Name</p><p class="font-medium"><?php echo e($patient->full_name); ?></p></div>
                    <div><p class="text-slate-500">Email</p><p class="font-medium"><?php echo e($patient->email ?: '-'); ?></p></div>
                    <div><p class="text-slate-500">Phone</p><p class="font-medium"><?php echo e($patient->phone ?: '-'); ?></p></div>
                    <div><p class="text-slate-500">Gender</p><p class="font-medium"><?php echo e(ucfirst($patient->gender ?: '-')); ?></p></div>
                    <div><p class="text-slate-500">DOB</p><p class="font-medium"><?php echo e(optional($patient->dob)->format('Y-m-d') ?: '-'); ?></p></div>
                </div>
            </div>

            <div class="rounded-xl border border-slate-200 bg-white shadow-sm overflow-hidden">
                <div class="border-b border-slate-200 px-4 py-3">
                    <h3 class="font-semibold text-slate-800">Order History</h3>
                </div>
                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead class="bg-slate-50 text-slate-600">
                            <tr>
                                <th class="px-4 py-2 text-left">Order</th>
                                <th class="px-4 py-2 text-left">Lab</th>
                                <th class="px-4 py-2 text-left">Status</th>
                                <th class="px-4 py-2 text-left">Total</th>
                                <th class="px-4 py-2 text-left">Paid</th>
                                <th class="px-4 py-2 text-left">Balance</th>
                                <th class="px-4 py-2 text-left">Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="border-t border-slate-100">
                                    <td class="px-4 py-2 font-medium">
                                        <a href="<?php echo e(route('frontdesk.orders.show', $order)); ?>" class="text-sky-700 hover:text-sky-800"><?php echo e($order->order_code); ?></a>
                                    </td>
                                    <td class="px-4 py-2"><?php echo e(optional($order->lab)->name); ?> <?php echo e(optional($order->lab)->branch_name); ?></td>
                                    <td class="px-4 py-2 uppercase text-xs"><?php echo e($order->status); ?></td>
                                    <td class="px-4 py-2"><?php echo e(number_format((float) $order->total, 2)); ?></td>
                                    <td class="px-4 py-2"><?php echo e(number_format((float) $order->paid, 2)); ?></td>
                                    <td class="px-4 py-2"><?php echo e(number_format((float) $order->balance, 2)); ?></td>
                                    <td class="px-4 py-2"><?php echo e(optional($order->created_at)->format('Y-m-d H:i')); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr><td colspan="7" class="px-4 py-5 text-slate-500">No orders found.</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="border-t border-slate-200 px-4 py-3"><?php echo e($orders->links()); ?></div>
            </div>

            <div class="grid gap-4 lg:grid-cols-2">
                <div class="rounded-xl border border-slate-200 bg-white shadow-sm overflow-hidden">
                    <div class="border-b border-slate-200 px-4 py-3">
                        <h3 class="font-semibold text-slate-800">Payment History</h3>
                    </div>
                    <div class="overflow-x-auto">
                        <table class="min-w-full text-sm">
                            <thead class="bg-slate-50 text-slate-600">
                                <tr>
                                    <th class="px-4 py-2 text-left">Order</th>
                                    <th class="px-4 py-2 text-left">Amount</th>
                                    <th class="px-4 py-2 text-left">Method</th>
                                    <th class="px-4 py-2 text-left">Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr class="border-t border-slate-100">
                                        <td class="px-4 py-2"><?php echo e($payment->order_code); ?></td>
                                        <td class="px-4 py-2"><?php echo e(number_format((float) $payment->amount, 2)); ?></td>
                                        <td class="px-4 py-2 uppercase text-xs"><?php echo e($payment->method); ?></td>
                                        <td class="px-4 py-2"><?php echo e(optional($payment->paid_at ?? $payment->created_at)->format('Y-m-d H:i')); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr><td colspan="4" class="px-4 py-5 text-slate-500">No payments found.</td></tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="border-t border-slate-200 px-4 py-3"><?php echo e($payments->links()); ?></div>
                </div>

                <div class="rounded-xl border border-slate-200 bg-white shadow-sm overflow-hidden">
                    <div class="border-b border-slate-200 px-4 py-3">
                        <h3 class="font-semibold text-slate-800">Result History</h3>
                    </div>
                    <div class="overflow-x-auto">
                        <table class="min-w-full text-sm">
                            <thead class="bg-slate-50 text-slate-600">
                                <tr>
                                    <th class="px-4 py-2 text-left">Order</th>
                                    <th class="px-4 py-2 text-left">Version</th>
                                    <th class="px-4 py-2 text-left">Uploaded</th>
                                    <th class="px-4 py-2 text-left">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr class="border-t border-slate-100">
                                        <td class="px-4 py-2"><?php echo e($result->order_code); ?></td>
                                        <td class="px-4 py-2"><?php echo e($result->version); ?></td>
                                        <td class="px-4 py-2"><?php echo e(optional($result->created_at)->format('Y-m-d H:i')); ?></td>
                                        <td class="px-4 py-2">
                                            <a href="<?php echo e(route('frontdesk.orders.results.download', [$result->order_id, $result->id])); ?>" class="text-sky-700 hover:text-sky-800">Download</a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr><td colspan="4" class="px-4 py-5 text-slate-500">No results found.</td></tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="border-t border-slate-200 px-4 py-3"><?php echo e($results->links()); ?></div>
                </div>
            </div>

            <div class="rounded-xl border border-slate-200 bg-white shadow-sm overflow-hidden">
                <div class="border-b border-slate-200 px-4 py-3">
                    <h3 class="font-semibold text-slate-800">OTP History</h3>
                </div>
                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead class="bg-slate-50 text-slate-600">
                            <tr>
                                <th class="px-4 py-2 text-left">OTP</th>
                                <th class="px-4 py-2 text-left">Channel</th>
                                <th class="px-4 py-2 text-left">Attempts</th>
                                <th class="px-4 py-2 text-left">Consumed</th>
                                <th class="px-4 py-2 text-left">Expires</th>
                                <th class="px-4 py-2 text-left">Sent</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $otpHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $otp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="border-t border-slate-100">
                                    <td class="px-4 py-2"><span class="inline-flex rounded bg-slate-900 px-2 py-1 text-xs font-mono text-white"><?php echo e($otp->plain_code ?: 'n/a'); ?></span></td>
                                    <td class="px-4 py-2 uppercase text-xs"><?php echo e($otp->channel); ?></td>
                                    <td class="px-4 py-2"><?php echo e($otp->attempts); ?></td>
                                    <td class="px-4 py-2"><?php echo e(optional($otp->consumed_at)->format('Y-m-d H:i:s') ?: '-'); ?></td>
                                    <td class="px-4 py-2"><?php echo e(optional($otp->expires_at)->format('Y-m-d H:i:s') ?: '-'); ?></td>
                                    <td class="px-4 py-2"><?php echo e(optional($otp->created_at)->format('Y-m-d H:i:s')); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr><td colspan="6" class="px-4 py-5 text-slate-500">No OTP history found.</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="border-t border-slate-200 px-4 py-3"><?php echo e($otpHistory->links()); ?></div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\wamp64\www\lab-result-portal\resources\views\frontdesk\patients\history.blade.php ENDPATH**/ ?>